/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns.policy;

import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.component.dns.policy.DnsActivation;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.RoutePolicySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsActivationPolicy
extends RoutePolicySupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(DnsActivationPolicy.class);
    private ExceptionHandler exceptionHandler;
    private DnsActivation dnsActivation;
    private long ttl;
    private boolean stopRoutesOnException;
    private Map<String, Route> routes = new ConcurrentHashMap<String, Route>();
    private Timer timer;

    public DnsActivationPolicy() {
        this.dnsActivation = new DnsActivation();
    }

    @Override
    public void onInit(Route route) {
        LOG.debug("onInit {}", (Object)route.getId());
        this.routes.put(route.getId(), route);
    }

    @Override
    public void onRemove(Route route) {
        LOG.debug("onRemove {}", (Object)route.getId());
    }

    @Override
    public void onStart(Route route) {
        LOG.debug("onStart {}", (Object)route.getId());
    }

    @Override
    public void onStop(Route route) {
        LOG.debug("onStop {}", (Object)route.getId());
    }

    @Override
    public void onSuspend(Route route) {
        LOG.debug("onSuspend {}", (Object)route.getId());
    }

    @Override
    public void onResume(Route route) {
        LOG.debug("onResume {}", (Object)route.getId());
    }

    @Override
    public void onExchangeBegin(Route route, Exchange exchange) {
        LOG.debug("onExchange start {}/{}", (Object)route.getId(), (Object)exchange.getExchangeId());
    }

    @Override
    public void onExchangeDone(Route route, Exchange exchange) {
        LOG.debug("onExchange end {}/{}", (Object)route.getId(), (Object)exchange.getExchangeId());
    }

    @Override
    protected void doStart() throws Exception {
        LOG.debug("doStart");
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new DnsActivationTask(), 0L, this.ttl);
    }

    @Override
    protected void doStop() throws Exception {
        LOG.debug("doStop");
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(null, this.getClass());
        }
        return this.exceptionHandler;
    }

    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setHostname(String hostname) {
        this.dnsActivation.setHostname(hostname);
    }

    public String getHostname() {
        return this.dnsActivation.getHostname();
    }

    public void setResolvesTo(List<String> resolvesTo) {
        this.dnsActivation.setResolvesTo(resolvesTo);
    }

    public void setResolvesTo(String resolvesTo) {
        this.dnsActivation.setResolvesTo(resolvesTo);
    }

    public List<String> getResolvesTo() {
        return this.dnsActivation.getResolvesTo();
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public void setTtl(String ttl) {
        this.ttl = Long.parseLong(ttl);
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setStopRoutesOnException(String stopRoutesOnException) {
        this.stopRoutesOnException = Boolean.parseBoolean(stopRoutesOnException);
    }

    private void startRouteImpl(Route route) throws Exception {
        ServiceStatus routeStatus = this.controller(route).getRouteStatus(route.getId());
        if (routeStatus == ServiceStatus.Stopped) {
            LOG.info("Starting {}", (Object)route.getId());
            this.startRoute(route);
        } else if (routeStatus == ServiceStatus.Suspended) {
            LOG.info("Resuming {}", (Object)route.getId());
            this.startConsumer(route.getConsumer());
        } else {
            LOG.debug("Nothing to do {} is {}", (Object)route.getId(), (Object)routeStatus);
        }
    }

    private void startRoutes() {
        for (Map.Entry<String, Route> entry : this.routes.entrySet()) {
            try {
                this.startRouteImpl(entry.getValue());
            }
            catch (Exception e) {
                LOG.warn(entry.getKey(), (Throwable)e);
            }
        }
    }

    private void stopRouteImpl(Route route) throws Exception {
        ServiceStatus routeStatus = this.controller(route).getRouteStatus(route.getId());
        if (routeStatus == ServiceStatus.Started) {
            LOG.info("Stopping {}", (Object)route.getId());
            this.stopRoute(route);
        } else {
            LOG.debug("Nothing to do {} is {}", (Object)route.getId(), (Object)routeStatus);
        }
    }

    private void stopRoutes() {
        for (Map.Entry<String, Route> routeEntry : this.routes.entrySet()) {
            try {
                this.stopRouteImpl(routeEntry.getValue());
            }
            catch (Exception e) {
                LOG.warn(routeEntry.getKey(), (Throwable)e);
            }
        }
    }

    protected boolean isActive() throws Exception {
        return this.dnsActivation.isActive();
    }

    class DnsActivationTask
    extends TimerTask {
        DnsActivationTask() {
        }

        @Override
        public void run() {
            block4: {
                try {
                    if (DnsActivationPolicy.this.isActive()) {
                        DnsActivationPolicy.this.startRoutes();
                    } else {
                        DnsActivationPolicy.this.stopRoutes();
                    }
                }
                catch (Exception e) {
                    LOG.warn("DnsActivation TimerTask failed", (Throwable)e);
                    if (!DnsActivationPolicy.this.stopRoutesOnException) break block4;
                    DnsActivationPolicy.this.stopRoutes();
                }
            }
        }
    }
}

