/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.routing;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterConfiguration;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterConstants;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.processor.aggregate.AggregationStrategyBiFunctionAdapter;
import org.apache.camel.processor.aggregate.ShareUnitOfWorkAggregationStrategy;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.util.ObjectHelper;

public final class DynamicRouterRecipientListHelper {
    private static final String ESM_NAME = "ExecutorServiceManager";
    static BiFunction<BiFunction<Exchange, Exchange, Object>, DynamicRouterConfiguration, AggregationStrategyBiFunctionAdapter> createBiFunctionAdapter = (bf, cfg) -> {
        AggregationStrategyBiFunctionAdapter adapter = new AggregationStrategyBiFunctionAdapter((BiFunction<Exchange, Exchange, Object>)bf);
        adapter.setAllowNullNewExchange(cfg.isAggregationStrategyMethodAllowNull());
        adapter.setAllowNullOldExchange(cfg.isAggregationStrategyMethodAllowNull());
        return adapter;
    };
    static BiFunction<Object, DynamicRouterConfiguration, AggregationStrategyBeanAdapter> createBeanAdapter = (obj, cfg) -> {
        AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(obj, cfg.getAggregationStrategyMethodName());
        adapter.setAllowNullNewExchange(cfg.isAggregationStrategyMethodAllowNull());
        adapter.setAllowNullOldExchange(cfg.isAggregationStrategyMethodAllowNull());
        return adapter;
    };
    static BiFunction<Object, DynamicRouterConfiguration, AggregationStrategy> convertAggregationStrategy = (aggStr, cfg) -> Optional.ofNullable(aggStr).filter(AggregationStrategy.class::isInstance).map(s -> (AggregationStrategy)s).or(() -> Optional.ofNullable(aggStr).filter(BiFunction.class::isInstance).map(s -> createBiFunctionAdapter.apply((BiFunction)s, (DynamicRouterConfiguration)cfg))).or(() -> Optional.ofNullable(aggStr).map(s -> createBeanAdapter.apply(s, (DynamicRouterConfiguration)cfg))).orElseThrow(() -> new IllegalArgumentException("Cannot convert AggregationStrategy from: " + String.valueOf(aggStr)));

    private DynamicRouterRecipientListHelper() {
    }

    public static Processor createProcessor(CamelContext camelContext, DynamicRouterConfiguration cfg, BiFunction<CamelContext, Expression, RecipientList> recipientListSupplier) {
        RecipientList recipientList = recipientListSupplier.apply(camelContext, DynamicRouterConstants.RECIPIENT_LIST_EXPRESSION);
        DynamicRouterRecipientListHelper.setPropertiesForRecipientList(recipientList, camelContext, cfg);
        ExecutorService threadPool = DynamicRouterRecipientListHelper.getConfiguredExecutorService(camelContext, "RecipientList", cfg, cfg.isParallelProcessing());
        recipientList.setExecutorService(threadPool);
        recipientList.setShutdownExecutorService(DynamicRouterRecipientListHelper.willCreateNewThreadPool(camelContext, cfg, cfg.isParallelProcessing()));
        recipientList.start();
        return recipientList;
    }

    static void setPropertiesForRecipientList(RecipientList recipientList, CamelContext camelContext, DynamicRouterConfiguration cfg) {
        recipientList.setAggregationStrategy(DynamicRouterRecipientListHelper.createAggregationStrategy(camelContext, cfg));
        recipientList.setParallelProcessing(cfg.isParallelProcessing());
        recipientList.setParallelAggregate(cfg.isParallelAggregate());
        recipientList.setSynchronous(cfg.isSynchronous());
        recipientList.setStreaming(cfg.isStreaming());
        recipientList.setShareUnitOfWork(cfg.isShareUnitOfWork());
        recipientList.setStopOnException(cfg.isStopOnException());
        recipientList.setIgnoreInvalidEndpoints(cfg.isIgnoreInvalidEndpoints());
        recipientList.setCacheSize(cfg.getCacheSize());
        if (cfg.getOnPrepare() != null) {
            recipientList.setOnPrepare(CamelContextHelper.mandatoryLookup(camelContext, cfg.getOnPrepare(), Processor.class));
        }
        if (cfg.getTimeout() > 0L && !cfg.isParallelProcessing()) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled.");
        }
        recipientList.setTimeout(cfg.getTimeout());
    }

    static AggregationStrategy createAggregationStrategy(CamelContext camelContext, DynamicRouterConfiguration cfg) {
        AggregationStrategy strategy = Optional.ofNullable(cfg.getAggregationStrategyBean()).or(() -> Optional.ofNullable(cfg.getAggregationStrategy()).map(ref -> DynamicRouterRecipientListHelper.lookupByNameAndType(camelContext, ref, Object.class).map(aggStr -> convertAggregationStrategy.apply(aggStr, cfg)).orElseThrow(() -> new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + cfg.getAggregationStrategy())))).orElse(new NoopAggregationStrategy());
        CamelContextAware.trySetCamelContext(strategy, camelContext);
        return cfg.isShareUnitOfWork() ? new ShareUnitOfWorkAggregationStrategy(strategy) : strategy;
    }

    static <T> Optional<T> lookupByNameAndType(CamelContext camelContext, String name, Class<T> type) {
        return Optional.ofNullable(ObjectHelper.isEmpty(name) ? null : name).map(n -> EndpointHelper.isReferenceParameter(n) ? EndpointHelper.resolveReferenceParameter(camelContext, n, type, false) : camelContext.getRegistry().lookupByNameAndType((String)n, type));
    }

    static boolean willCreateNewThreadPool(CamelContext camelContext, DynamicRouterConfiguration cfg, boolean useDefault) {
        ObjectHelper.notNull(camelContext.getExecutorServiceManager(), ESM_NAME, camelContext);
        return Optional.ofNullable(cfg.getExecutorServiceBean()).map(esb -> false).or(() -> Optional.ofNullable(cfg.getExecutorService()).map(es -> DynamicRouterRecipientListHelper.lookupByNameAndType(camelContext, es, ExecutorService.class).isEmpty())).orElse(useDefault);
    }

    static Optional<ExecutorService> lookupExecutorServiceRef(CamelContext camelContext, String name, Object source, String executorServiceRef) {
        ExecutorServiceManager manager = camelContext.getExecutorServiceManager();
        ObjectHelper.notNull(manager, ESM_NAME);
        ObjectHelper.notNull(executorServiceRef, "executorServiceRef");
        return DynamicRouterRecipientListHelper.lookupByNameAndType(camelContext, executorServiceRef, ExecutorService.class).or(() -> Optional.ofNullable(manager.newThreadPool(source, name, executorServiceRef)));
    }

    static ExecutorService getConfiguredExecutorService(CamelContext camelContext, String name, DynamicRouterConfiguration cfg, boolean useDefault) throws IllegalArgumentException {
        ExecutorServiceManager manager = camelContext.getExecutorServiceManager();
        ObjectHelper.notNull(manager, ESM_NAME, camelContext);
        String exSvcRef = cfg.getExecutorService();
        ExecutorService exSvcBean = cfg.getExecutorServiceBean();
        String errorMessage = "ExecutorServiceRef '" + exSvcRef + "' not found in registry as an ExecutorService instance or as a thread pool profile";
        return Optional.ofNullable(exSvcBean).or(() -> Optional.ofNullable(exSvcRef).map(r -> DynamicRouterRecipientListHelper.lookupExecutorServiceRef(camelContext, name, cfg, r).orElseThrow(() -> new IllegalArgumentException(errorMessage)))).or(() -> useDefault ? Optional.of(manager.newDefaultThreadPool(cfg, name)) : Optional.empty()).orElse(null);
    }

    public static class NoopAggregationStrategy
    implements AggregationStrategy {
        @Override
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            return oldExchange == null ? newExchange : oldExchange;
        }
    }
}

