/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter.routing;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.dynamicrouter.filter.DynamicRouterFilterService;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterComponent;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterConfiguration;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterConstants;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterProcessor;
import org.apache.camel.component.dynamicrouter.routing.DynamicRouterProducer;
import org.apache.camel.processor.RecipientList;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.15.0", scheme="dynamic-router", title="Dynamic Router", syntax="dynamic-router:channel", producerOnly=true, remote=false, category={Category.MESSAGING, Category.CORE})
public class DynamicRouterEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicRouterEndpoint.class);
    private final Supplier<DynamicRouterProcessor.DynamicRouterProcessorFactory> processorFactorySupplier;
    private final Supplier<DynamicRouterProducer.DynamicRouterProducerFactory> producerFactorySupplier;
    private final BiFunction<CamelContext, Expression, RecipientList> recipientListSupplier;
    @UriPath
    private final String channel;
    @UriParam
    private final DynamicRouterConfiguration configuration;
    private final DynamicRouterFilterService filterService;

    public DynamicRouterEndpoint(String uri, DynamicRouterComponent component, DynamicRouterConfiguration configuration, Supplier<DynamicRouterProcessor.DynamicRouterProcessorFactory> processorFactorySupplier, Supplier<DynamicRouterProducer.DynamicRouterProducerFactory> producerFactorySupplier, BiFunction<CamelContext, Expression, RecipientList> recipientListSupplier, DynamicRouterFilterService filterService) {
        super(uri, component);
        this.channel = configuration.getChannel();
        this.configuration = configuration;
        this.processorFactorySupplier = processorFactorySupplier;
        this.producerFactorySupplier = producerFactorySupplier;
        this.recipientListSupplier = recipientListSupplier;
        this.configuration.setChannel(this.channel);
        this.filterService = filterService;
        LOG.debug("Created Dynamic Router endpoint URI: {}", (Object)uri);
    }

    public DynamicRouterEndpoint(String uri, DynamicRouterComponent component, DynamicRouterConfiguration configuration, DynamicRouterFilterService filterService) {
        super(uri, component);
        this.processorFactorySupplier = DynamicRouterConstants.PROCESSOR_FACTORY_SUPPLIER;
        this.producerFactorySupplier = DynamicRouterConstants.PRODUCER_FACTORY_SUPPLIER;
        this.recipientListSupplier = DynamicRouterConstants.RECIPIENT_LIST_SUPPLIER;
        this.channel = configuration.getChannel();
        this.configuration = configuration;
        this.filterService = filterService;
        LOG.debug("Created Dynamic Router Control Channel endpoint URI: {}", (Object)uri);
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        DynamicRouterComponent component = this.getDynamicRouterComponent();
        CamelContext camelContext = this.getCamelContext();
        DynamicRouterProcessor processor = this.processorFactorySupplier.get().getInstance(camelContext, this.configuration, this.filterService, this.recipientListSupplier);
        component.addRoutingProcessor(this.configuration.getChannel(), processor);
    }

    @Override
    public Producer createProducer() {
        return this.producerFactorySupplier.get().getInstance(this, this.getDynamicRouterComponent(), this.configuration);
    }

    @Override
    public Consumer createConsumer(Processor processor) {
        throw new IllegalStateException("Dynamic Router is a producer-only component");
    }

    public DynamicRouterComponent getDynamicRouterComponent() {
        return (DynamicRouterComponent)this.getComponent();
    }

    public DynamicRouterConfiguration getConfiguration() {
        return this.configuration;
    }

    public static class DynamicRouterEndpointFactory {
        public DynamicRouterEndpoint getInstance(String uri, DynamicRouterComponent component, DynamicRouterConfiguration configuration, Supplier<DynamicRouterProcessor.DynamicRouterProcessorFactory> processorFactorySupplier, Supplier<DynamicRouterProducer.DynamicRouterProducerFactory> producerFactorySupplier, BiFunction<CamelContext, Expression, RecipientList> recipientListSupplier, DynamicRouterFilterService filterService) {
            return new DynamicRouterEndpoint(uri, component, configuration, processorFactorySupplier, producerFactorySupplier, recipientListSupplier, filterService);
        }

        public DynamicRouterEndpoint getInstance(String uri, DynamicRouterComponent component, DynamicRouterConfiguration configuration, DynamicRouterFilterService filterService) {
            return new DynamicRouterEndpoint(uri, component, configuration, filterService);
        }
    }
}

