/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.FormatMetricAggregationBase;
import co.elastic.clients.elasticsearch._types.aggregations.HdrMethod;
import co.elastic.clients.elasticsearch._types.aggregations.TDigest;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PercentilesAggregation
extends FormatMetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Boolean keyed;
    private final List<Double> percents;
    @Nullable
    private final HdrMethod hdr;
    @Nullable
    private final TDigest tdigest;
    public static final JsonpDeserializer<PercentilesAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PercentilesAggregation::setupPercentilesAggregationDeserializer);

    private PercentilesAggregation(Builder builder) {
        super(builder);
        this.keyed = builder.keyed;
        this.percents = ApiTypeHelper.unmodifiable(builder.percents);
        this.hdr = builder.hdr;
        this.tdigest = builder.tdigest;
    }

    public static PercentilesAggregation of(Function<Builder, ObjectBuilder<PercentilesAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Percentiles;
    }

    @Nullable
    public final Boolean keyed() {
        return this.keyed;
    }

    public final List<Double> percents() {
        return this.percents;
    }

    @Nullable
    public final HdrMethod hdr() {
        return this.hdr;
    }

    @Nullable
    public final TDigest tdigest() {
        return this.tdigest;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.keyed != null) {
            generator.writeKey("keyed");
            generator.write(this.keyed);
        }
        if (ApiTypeHelper.isDefined(this.percents)) {
            generator.writeKey("percents");
            generator.writeStartArray();
            for (Double item0 : this.percents) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.hdr != null) {
            generator.writeKey("hdr");
            this.hdr.serialize(generator, mapper);
        }
        if (this.tdigest != null) {
            generator.writeKey("tdigest");
            this.tdigest.serialize(generator, mapper);
        }
    }

    protected static void setupPercentilesAggregationDeserializer(ObjectDeserializer<Builder> op) {
        FormatMetricAggregationBase.setupFormatMetricAggregationBaseDeserializer(op);
        op.add(Builder::keyed, JsonpDeserializer.booleanDeserializer(), "keyed");
        op.add(Builder::percents, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "percents");
        op.add(Builder::hdr, HdrMethod._DESERIALIZER, "hdr");
        op.add(Builder::tdigest, TDigest._DESERIALIZER, "tdigest");
    }

    public static class Builder
    extends FormatMetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PercentilesAggregation> {
        @Nullable
        private Boolean keyed;
        @Nullable
        private List<Double> percents;
        @Nullable
        private HdrMethod hdr;
        @Nullable
        private TDigest tdigest;

        public final Builder keyed(@Nullable Boolean value) {
            this.keyed = value;
            return this;
        }

        public final Builder percents(List<Double> list) {
            this.percents = Builder._listAddAll(this.percents, list);
            return this;
        }

        public final Builder percents(Double value, Double ... values) {
            this.percents = Builder._listAdd(this.percents, value, values);
            return this;
        }

        public final Builder hdr(@Nullable HdrMethod value) {
            this.hdr = value;
            return this;
        }

        public final Builder hdr(Function<HdrMethod.Builder, ObjectBuilder<HdrMethod>> fn) {
            return this.hdr(fn.apply(new HdrMethod.Builder()).build());
        }

        public final Builder tdigest(@Nullable TDigest value) {
            this.tdigest = value;
            return this;
        }

        public final Builder tdigest(Function<TDigest.Builder, ObjectBuilder<TDigest>> fn) {
            return this.tdigest(fn.apply(new TDigest.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PercentilesAggregation build() {
            this._checkSingleUse();
            return new PercentilesAggregation(this);
        }
    }
}

