/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class KeywordMarkerTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final Boolean ignoreCase;
    private final List<String> keywords;
    @Nullable
    private final String keywordsPath;
    @Nullable
    private final String keywordsPattern;
    public static final JsonpDeserializer<KeywordMarkerTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KeywordMarkerTokenFilter::setupKeywordMarkerTokenFilterDeserializer);

    private KeywordMarkerTokenFilter(Builder builder) {
        super(builder);
        this.ignoreCase = builder.ignoreCase;
        this.keywords = ApiTypeHelper.unmodifiable(builder.keywords);
        this.keywordsPath = builder.keywordsPath;
        this.keywordsPattern = builder.keywordsPattern;
    }

    public static KeywordMarkerTokenFilter of(Function<Builder, ObjectBuilder<KeywordMarkerTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.KeywordMarker;
    }

    @Nullable
    public final Boolean ignoreCase() {
        return this.ignoreCase;
    }

    public final List<String> keywords() {
        return this.keywords;
    }

    @Nullable
    public final String keywordsPath() {
        return this.keywordsPath;
    }

    @Nullable
    public final String keywordsPattern() {
        return this.keywordsPattern;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "keyword_marker");
        super.serializeInternal(generator, mapper);
        if (this.ignoreCase != null) {
            generator.writeKey("ignore_case");
            generator.write(this.ignoreCase);
        }
        if (ApiTypeHelper.isDefined(this.keywords)) {
            generator.writeKey("keywords");
            generator.writeStartArray();
            for (String item0 : this.keywords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.keywordsPath != null) {
            generator.writeKey("keywords_path");
            generator.write(this.keywordsPath);
        }
        if (this.keywordsPattern != null) {
            generator.writeKey("keywords_pattern");
            generator.write(this.keywordsPattern);
        }
    }

    protected static void setupKeywordMarkerTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::ignoreCase, JsonpDeserializer.booleanDeserializer(), "ignore_case");
        op.add(Builder::keywords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "keywords");
        op.add(Builder::keywordsPath, JsonpDeserializer.stringDeserializer(), "keywords_path");
        op.add(Builder::keywordsPattern, JsonpDeserializer.stringDeserializer(), "keywords_pattern");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KeywordMarkerTokenFilter> {
        @Nullable
        private Boolean ignoreCase;
        @Nullable
        private List<String> keywords;
        @Nullable
        private String keywordsPath;
        @Nullable
        private String keywordsPattern;

        public final Builder ignoreCase(@Nullable Boolean value) {
            this.ignoreCase = value;
            return this;
        }

        public final Builder keywords(List<String> list) {
            this.keywords = Builder._listAddAll(this.keywords, list);
            return this;
        }

        public final Builder keywords(String value, String ... values) {
            this.keywords = Builder._listAdd(this.keywords, value, values);
            return this;
        }

        public final Builder keywordsPath(@Nullable String value) {
            this.keywordsPath = value;
            return this;
        }

        public final Builder keywordsPattern(@Nullable String value) {
            this.keywordsPattern = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KeywordMarkerTokenFilter build() {
            this._checkSingleUse();
            return new KeywordMarkerTokenFilter(this);
        }
    }
}

