/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DisMaxQuery
extends QueryBase
implements QueryVariant {
    private final List<Query> queries;
    @Nullable
    private final Double tieBreaker;
    public static final JsonpDeserializer<DisMaxQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DisMaxQuery::setupDisMaxQueryDeserializer);

    private DisMaxQuery(Builder builder) {
        super(builder);
        this.queries = ApiTypeHelper.unmodifiableRequired(builder.queries, (Object)this, "queries");
        this.tieBreaker = builder.tieBreaker;
    }

    public static DisMaxQuery of(Function<Builder, ObjectBuilder<DisMaxQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.DisMax;
    }

    public final List<Query> queries() {
        return this.queries;
    }

    @Nullable
    public final Double tieBreaker() {
        return this.tieBreaker;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.queries)) {
            generator.writeKey("queries");
            generator.writeStartArray();
            for (Query item0 : this.queries) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tieBreaker != null) {
            generator.writeKey("tie_breaker");
            generator.write(this.tieBreaker);
        }
    }

    protected static void setupDisMaxQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::queries, JsonpDeserializer.arrayDeserializer(Query._DESERIALIZER), "queries");
        op.add(Builder::tieBreaker, JsonpDeserializer.doubleDeserializer(), "tie_breaker");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DisMaxQuery> {
        private List<Query> queries;
        @Nullable
        private Double tieBreaker;

        public final Builder queries(List<Query> list) {
            this.queries = Builder._listAddAll(this.queries, list);
            return this;
        }

        public final Builder queries(Query value, Query ... values) {
            this.queries = Builder._listAdd(this.queries, value, values);
            return this;
        }

        public final Builder queries(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.queries(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        public final Builder tieBreaker(@Nullable Double value) {
            this.tieBreaker = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DisMaxQuery build() {
            this._checkSingleUse();
            return new DisMaxQuery(this);
        }
    }
}

