/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.knn_search;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class KnnSearchQuery
implements JsonpSerializable {
    private final String field;
    private final List<Float> queryVector;
    private final int k;
    private final int numCandidates;
    public static final JsonpDeserializer<KnnSearchQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KnnSearchQuery::setupKnnSearchQueryDeserializer);

    private KnnSearchQuery(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.queryVector = ApiTypeHelper.unmodifiableRequired(builder.queryVector, (Object)this, "queryVector");
        this.k = ApiTypeHelper.requireNonNull(builder.k, this, "k");
        this.numCandidates = ApiTypeHelper.requireNonNull(builder.numCandidates, this, "numCandidates");
    }

    public static KnnSearchQuery of(Function<Builder, ObjectBuilder<KnnSearchQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    public final List<Float> queryVector() {
        return this.queryVector;
    }

    public final int k() {
        return this.k;
    }

    public final int numCandidates() {
        return this.numCandidates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.queryVector)) {
            generator.writeKey("query_vector");
            generator.writeStartArray();
            for (Float item0 : this.queryVector) {
                generator.write(item0.floatValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("k");
        generator.write(this.k);
        generator.writeKey("num_candidates");
        generator.write(this.numCandidates);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupKnnSearchQueryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::queryVector, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.floatDeserializer()), "query_vector");
        op.add(Builder::k, JsonpDeserializer.integerDeserializer(), "k");
        op.add(Builder::numCandidates, JsonpDeserializer.integerDeserializer(), "num_candidates");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<KnnSearchQuery> {
        private String field;
        private List<Float> queryVector;
        private Integer k;
        private Integer numCandidates;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder queryVector(List<Float> list) {
            this.queryVector = Builder._listAddAll(this.queryVector, list);
            return this;
        }

        public final Builder queryVector(Float value, Float ... values) {
            this.queryVector = Builder._listAdd(this.queryVector, value, values);
            return this;
        }

        public final Builder k(int value) {
            this.k = value;
            return this;
        }

        public final Builder numCandidates(int value) {
            this.numCandidates = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KnnSearchQuery build() {
            this._checkSingleUse();
            return new KnnSearchQuery(this);
        }
    }
}

