/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RemoveProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final List<String> field;
    private final List<String> keep;
    @Nullable
    private final Boolean ignoreMissing;
    public static final JsonpDeserializer<RemoveProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemoveProcessor::setupRemoveProcessorDeserializer);

    private RemoveProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.unmodifiableRequired(builder.field, (Object)this, "field");
        this.keep = ApiTypeHelper.unmodifiable(builder.keep);
        this.ignoreMissing = builder.ignoreMissing;
    }

    public static RemoveProcessor of(Function<Builder, ObjectBuilder<RemoveProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Remove;
    }

    public final List<String> field() {
        return this.field;
    }

    public final List<String> keep() {
        return this.keep;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.field)) {
            generator.writeKey("field");
            generator.writeStartArray();
            for (String item0 : this.field) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.keep)) {
            generator.writeKey("keep");
            generator.writeStartArray();
            for (String item0 : this.keep) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing);
        }
    }

    protected static void setupRemoveProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "field");
        op.add(Builder::keep, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "keep");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RemoveProcessor> {
        private List<String> field;
        @Nullable
        private List<String> keep;
        @Nullable
        private Boolean ignoreMissing;

        public final Builder field(List<String> list) {
            this.field = Builder._listAddAll(this.field, list);
            return this;
        }

        public final Builder field(String value, String ... values) {
            this.field = Builder._listAdd(this.field, value, values);
            return this;
        }

        public final Builder keep(List<String> list) {
            this.keep = Builder._listAddAll(this.keep, list);
            return this;
        }

        public final Builder keep(String value, String ... values) {
            this.keep = Builder._listAdd(this.keep, value, values);
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RemoveProcessor build() {
            this._checkSingleUse();
            return new RemoveProcessor(this);
        }
    }
}

