/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.stats;

import co.elastic.clients.elasticsearch.nodes.NodesResponseBase;
import co.elastic.clients.elasticsearch.nodes.Stats;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class ResponseBase
extends NodesResponseBase {
    @Nullable
    private final String clusterName;
    private final Map<String, Stats> nodes;

    protected ResponseBase(AbstractBuilder<?> builder) {
        super(builder);
        this.clusterName = ((AbstractBuilder)builder).clusterName;
        this.nodes = ApiTypeHelper.unmodifiableRequired(((AbstractBuilder)builder).nodes, (Object)this, "nodes");
    }

    @Nullable
    public final String clusterName() {
        return this.clusterName;
    }

    public final Map<String, Stats> nodes() {
        return this.nodes;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.clusterName != null) {
            generator.writeKey("cluster_name");
            generator.write(this.clusterName);
        }
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry<String, Stats> item0 : this.nodes.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        NodesResponseBase.setupNodesResponseBaseDeserializer(op);
        op.add(AbstractBuilder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(AbstractBuilder::nodes, JsonpDeserializer.stringMapDeserializer(Stats._DESERIALIZER), "nodes");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends NodesResponseBase.AbstractBuilder<BuilderT> {
        @Nullable
        private String clusterName;
        private Map<String, Stats> nodes;

        public final BuilderT clusterName(@Nullable String value) {
            this.clusterName = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT nodes(Map<String, Stats> map) {
            this.nodes = AbstractBuilder._mapPutAll(this.nodes, map);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT nodes(String key, Stats value) {
            this.nodes = AbstractBuilder._mapPut(this.nodes, key, value);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT nodes(String key, Function<Stats.Builder, ObjectBuilder<Stats>> fn) {
            return this.nodes(key, fn.apply(new Stats.Builder()).build());
        }
    }
}

