/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.BuildFunctionDeserializer;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.LazyDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonParser;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ObjectBuilderDeserializer<T, B extends ObjectBuilder<T>>
extends DelegatingDeserializer<T, B> {
    private final JsonpDeserializer<B> builderDeserializer;

    public static <B extends ObjectBuilder<T>, T> JsonpDeserializer<T> lazy(Supplier<B> builderCtor, Consumer<ObjectDeserializer<B>> builderDeserializerSetup) {
        return new LazyDeserializer(() -> {
            ObjectDeserializer builderDeser = new ObjectDeserializer(builderCtor);
            builderDeserializerSetup.accept(builderDeser);
            return new ObjectBuilderDeserializer(builderDeser);
        });
    }

    public static <B, T> JsonpDeserializer<T> lazy(Supplier<B> builderCtor, Consumer<ObjectDeserializer<B>> builderDeserializerSetup, Function<B, T> buildFn) {
        return new LazyDeserializer(() -> {
            ObjectDeserializer builderDeser = new ObjectDeserializer(builderCtor);
            builderDeserializerSetup.accept(builderDeser);
            return new BuildFunctionDeserializer(builderDeser, buildFn);
        });
    }

    public static <T, B extends ObjectBuilder<T>> JsonpDeserializer<T> createForObject(Supplier<B> ctor, Consumer<ObjectDeserializer<B>> configurer) {
        ObjectDeserializer<B> op = new ObjectDeserializer<B>(ctor);
        configurer.accept(op);
        return new ObjectBuilderDeserializer<T, B>(op);
    }

    public ObjectBuilderDeserializer(JsonpDeserializer<B> builderDeserializer) {
        this.builderDeserializer = builderDeserializer;
    }

    @Override
    protected JsonpDeserializer<B> unwrap() {
        return this.builderDeserializer;
    }

    @Override
    public T deserialize(JsonParser parser, JsonpMapper mapper) {
        ObjectBuilder builder = (ObjectBuilder)this.builderDeserializer.deserialize(parser, mapper);
        return builder == null ? null : (T)builder.build();
    }

    @Override
    public T deserialize(JsonParser parser, JsonpMapper mapper, JsonParser.Event event) {
        ObjectBuilder builder = (ObjectBuilder)this.builderDeserializer.deserialize(parser, mapper, event);
        return builder == null ? null : (T)builder.build();
    }
}

