/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jackson;

import co.elastic.clients.json.BufferingJsonGenerator;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.jackson.JacksonJsonBuffer;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpParser;
import co.elastic.clients.json.jackson.JacksonUtils;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerationException;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public class JacksonJsonpGenerator
implements JsonGenerator {
    private final com.fasterxml.jackson.core.JsonGenerator generator;

    public JacksonJsonpGenerator(com.fasterxml.jackson.core.JsonGenerator generator) {
        this.generator = generator;
    }

    public com.fasterxml.jackson.core.JsonGenerator jacksonGenerator() {
        return this.generator;
    }

    @Override
    public JsonGenerator writeStartObject() {
        try {
            this.generator.writeStartObject();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartObject(String name) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeStartObject();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartArray() {
        try {
            this.generator.writeStartArray();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator writeStartArray(String name) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeStartArray();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator writeKey(String name) {
        try {
            this.generator.writeFieldName(name);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, JsonValue value) {
        try {
            this.generator.writeFieldName(name);
            this.writeValue(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, String value) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeString(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, BigInteger value) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, BigDecimal value) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, int value) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, long value) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, double value) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String name, boolean value) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeBoolean(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator writeNull(String name) {
        try {
            this.generator.writeFieldName(name);
            this.generator.writeNull();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator writeEnd() {
        block4: {
            try {
                JsonStreamContext ctx = this.generator.getOutputContext();
                if (ctx.inObject()) {
                    this.generator.writeEndObject();
                    break block4;
                }
                if (ctx.inArray()) {
                    this.generator.writeEndArray();
                    break block4;
                }
                throw new JsonGenerationException("Unexpected context: '" + ctx.typeDesc() + "'");
            }
            catch (IOException e) {
                throw JacksonUtils.convertException(e);
            }
        }
        return this;
    }

    @Override
    public JsonGenerator write(JsonValue value) {
        try {
            this.writeValue(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(String value) {
        try {
            this.generator.writeString(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(BigDecimal value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(BigInteger value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(int value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(long value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(double value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator write(boolean value) {
        try {
            this.generator.writeBoolean(value);
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public JsonGenerator writeNull() {
        try {
            this.generator.writeNull();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.generator.close();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.generator.flush();
        }
        catch (IOException e) {
            throw JacksonUtils.convertException(e);
        }
    }

    private void writeValue(JsonValue value) throws IOException {
        switch (value.getValueType()) {
            case OBJECT: {
                this.generator.writeStartObject();
                for (Map.Entry entry : value.asJsonObject().entrySet()) {
                    this.generator.writeFieldName((String)entry.getKey());
                    this.writeValue((JsonValue)entry.getValue());
                }
                this.generator.writeEndObject();
                break;
            }
            case ARRAY: {
                this.generator.writeStartArray();
                for (JsonValue item : value.asJsonArray()) {
                    this.writeValue(item);
                }
                this.generator.writeEndArray();
                break;
            }
            case STRING: {
                this.generator.writeString(((JsonString)value).getString());
                break;
            }
            case FALSE: {
                this.generator.writeBoolean(false);
                break;
            }
            case TRUE: {
                this.generator.writeBoolean(true);
                break;
            }
            case NULL: {
                this.generator.writeNull();
                break;
            }
            case NUMBER: {
                JsonNumber n = (JsonNumber)value;
                if (n.isIntegral()) {
                    this.generator.writeNumber(n.longValue());
                    break;
                }
                this.generator.writeNumber(n.doubleValue());
            }
        }
    }

    public static class Buffering
    extends JacksonJsonpGenerator
    implements BufferingJsonGenerator {
        private final JacksonJsonpMapper mapper;

        public Buffering(JacksonJsonpMapper mapper) {
            super(new TokenBuffer(mapper.objectMapper(), false));
            this.mapper = mapper;
        }

        @Override
        public JsonData getJsonData() {
            this.close();
            return new JacksonJsonBuffer((TokenBuffer)this.jacksonGenerator(), this.mapper);
        }

        @Override
        public JsonParser getParser() {
            this.close();
            TokenBuffer tokenBuffer = (TokenBuffer)this.jacksonGenerator();
            return new JacksonJsonpParser(tokenBuffer.asParser(), this.mapper);
        }

        @Override
        public void copyValue(JsonParser parser) {
            if (!(parser instanceof JacksonJsonpGenerator)) {
                throw new IllegalArgumentException("Can only be used with a JacksonJsonpGenerator");
            }
            com.fasterxml.jackson.core.JsonParser jkParser = ((JacksonJsonpParser)parser).jacksonParser();
            try {
                this.jacksonGenerator().copyCurrentStructure(jkParser);
            }
            catch (IOException e) {
                throw JacksonUtils.convertException(e);
            }
        }
    }
}

