/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport.rest_client;

import co.elastic.clients.util.NoCopyByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Iterator;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.HttpAsyncContentProducer;

class MultiBufferEntity
extends AbstractHttpEntity
implements HttpAsyncContentProducer {
    private final Iterable<ByteBuffer> buffers;
    private Iterator<ByteBuffer> iterator;
    private volatile ByteBuffer currentBuffer;

    MultiBufferEntity(Iterable<ByteBuffer> buffers, ContentType contentType) {
        this.buffers = buffers;
        this.setChunked(true);
        if (contentType != null) {
            this.setContentType(contentType.toString());
        }
        this.init();
    }

    @Override
    public void close() throws IOException {
        this.init();
    }

    private void init() {
        this.iterator = this.buffers.iterator();
        this.currentBuffer = this.iterator.hasNext() ? this.iterator.next().duplicate() : null;
    }

    @Override
    public boolean isRepeatable() {
        return true;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public boolean isStreaming() {
        return false;
    }

    @Override
    public InputStream getContent() throws IOException, UnsupportedOperationException {
        NoCopyByteArrayOutputStream baos = new NoCopyByteArrayOutputStream();
        this.writeTo(baos);
        return baos.asInputStream();
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        WritableByteChannel channel = Channels.newChannel(out);
        for (ByteBuffer buffer : this.buffers) {
            channel.write(buffer.duplicate());
        }
    }

    @Override
    public void produceContent(ContentEncoder encoder, IOControl ioControl) throws IOException {
        if (this.currentBuffer == null) {
            encoder.complete();
            return;
        }
        encoder.write(this.currentBuffer);
        if (!this.currentBuffer.hasRemaining()) {
            if (this.iterator.hasNext()) {
                this.currentBuffer = this.iterator.next().duplicate();
            } else {
                this.currentBuffer = null;
                encoder.complete();
            }
        }
    }
}

