/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.es;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.es.ElasticsearchComponent;
import org.apache.camel.component.es.ElasticsearchConfiguration;
import org.apache.camel.component.es.ElasticsearchConstants;
import org.apache.camel.component.es.ElasticsearchProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.elasticsearch.client.RestClient;

@UriEndpoint(firstVersion="3.19.0", scheme="elasticsearch", title="Elasticsearch", syntax="elasticsearch:clusterName", producerOnly=true, category={Category.SEARCH, Category.MONITORING}, headersClass=ElasticsearchConstants.class)
public class ElasticsearchEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @UriParam
    private final ElasticsearchConfiguration configuration;
    private final RestClient client;

    public ElasticsearchEndpoint(String uri, ElasticsearchComponent component, ElasticsearchConfiguration config, RestClient client) {
        super(uri, component);
        this.configuration = config;
        this.client = client;
    }

    public ElasticsearchConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String getServiceUrl() {
        return this.getConfiguration().getHostAddresses();
    }

    @Override
    public String getServiceProtocol() {
        return "elasticsearch";
    }

    @Override
    public Producer createProducer() {
        return new ElasticsearchProducer(this, this.configuration);
    }

    @Override
    public Consumer createConsumer(Processor processor) {
        throw new UnsupportedOperationException("Cannot consume from an ElasticsearchEndpoint: " + this.getEndpointUri());
    }

    public RestClient getClient() {
        return this.client;
    }
}

