/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.es.aggregation;

import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import java.util.List;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;

@Metadata(label="bean", description="Aggregates two ElasticSearch BulkOperation into a single BulkRequest", annotations={"interfaceName=org.apache.camel.AggregationStrategy"})
@Configurer(metadataOnly=true)
public class ElasticsearchBulkRequestAggregationStrategy
implements AggregationStrategy {
    @Override
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        Object objBody = newExchange.getIn().getBody();
        if (!(objBody instanceof BulkOperation[])) {
            throw new InvalidPayloadRuntimeException(newExchange, BulkOperation[].class);
        }
        BulkOperation[] newBody = (BulkOperation[])objBody;
        BulkRequest.Builder builder = new BulkRequest.Builder();
        builder.operations(List.of(newBody));
        if (oldExchange != null) {
            BulkRequest request = oldExchange.getIn().getBody(BulkRequest.class);
            builder.operations(request.operations());
        }
        newExchange.getIn().setBody(builder.build());
        return oldExchange;
    }
}

