/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.analysis.IcuCollationAlternate;
import co.elastic.clients.elasticsearch._types.analysis.IcuCollationCaseFirst;
import co.elastic.clients.elasticsearch._types.analysis.IcuCollationDecomposition;
import co.elastic.clients.elasticsearch._types.analysis.IcuCollationStrength;
import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.IndexOptions;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IcuCollationProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean norms;
    @Nullable
    private final IndexOptions indexOptions;
    @Nullable
    private final Boolean index;
    @Nullable
    private final String nullValue;
    @Nullable
    private final String rules;
    @Nullable
    private final String language;
    @Nullable
    private final String country;
    @Nullable
    private final String variant;
    @Nullable
    private final IcuCollationStrength strength;
    @Nullable
    private final IcuCollationDecomposition decomposition;
    @Nullable
    private final IcuCollationAlternate alternate;
    @Nullable
    private final Boolean caseLevel;
    @Nullable
    private final IcuCollationCaseFirst caseFirst;
    @Nullable
    private final Boolean numeric;
    @Nullable
    private final String variableTop;
    @Nullable
    private final Boolean hiraganaQuaternaryMode;
    public static final JsonpDeserializer<IcuCollationProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuCollationProperty::setupIcuCollationPropertyDeserializer);

    private IcuCollationProperty(Builder builder) {
        super(builder);
        this.norms = builder.norms;
        this.indexOptions = builder.indexOptions;
        this.index = builder.index;
        this.nullValue = builder.nullValue;
        this.rules = builder.rules;
        this.language = builder.language;
        this.country = builder.country;
        this.variant = builder.variant;
        this.strength = builder.strength;
        this.decomposition = builder.decomposition;
        this.alternate = builder.alternate;
        this.caseLevel = builder.caseLevel;
        this.caseFirst = builder.caseFirst;
        this.numeric = builder.numeric;
        this.variableTop = builder.variableTop;
        this.hiraganaQuaternaryMode = builder.hiraganaQuaternaryMode;
    }

    public static IcuCollationProperty of(Function<Builder, ObjectBuilder<IcuCollationProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.IcuCollationKeyword;
    }

    @Nullable
    public final Boolean norms() {
        return this.norms;
    }

    @Nullable
    public final IndexOptions indexOptions() {
        return this.indexOptions;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final String nullValue() {
        return this.nullValue;
    }

    @Nullable
    public final String rules() {
        return this.rules;
    }

    @Nullable
    public final String language() {
        return this.language;
    }

    @Nullable
    public final String country() {
        return this.country;
    }

    @Nullable
    public final String variant() {
        return this.variant;
    }

    @Nullable
    public final IcuCollationStrength strength() {
        return this.strength;
    }

    @Nullable
    public final IcuCollationDecomposition decomposition() {
        return this.decomposition;
    }

    @Nullable
    public final IcuCollationAlternate alternate() {
        return this.alternate;
    }

    @Nullable
    public final Boolean caseLevel() {
        return this.caseLevel;
    }

    @Nullable
    public final IcuCollationCaseFirst caseFirst() {
        return this.caseFirst;
    }

    @Nullable
    public final Boolean numeric() {
        return this.numeric;
    }

    @Nullable
    public final String variableTop() {
        return this.variableTop;
    }

    @Nullable
    public final Boolean hiraganaQuaternaryMode() {
        return this.hiraganaQuaternaryMode;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_collation_keyword");
        super.serializeInternal(generator, mapper);
        if (this.norms != null) {
            generator.writeKey("norms");
            generator.write(this.norms);
        }
        if (this.indexOptions != null) {
            generator.writeKey("index_options");
            this.indexOptions.serialize(generator, mapper);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue);
        }
        if (this.rules != null) {
            generator.writeKey("rules");
            generator.write(this.rules);
        }
        if (this.language != null) {
            generator.writeKey("language");
            generator.write(this.language);
        }
        if (this.country != null) {
            generator.writeKey("country");
            generator.write(this.country);
        }
        if (this.variant != null) {
            generator.writeKey("variant");
            generator.write(this.variant);
        }
        if (this.strength != null) {
            generator.writeKey("strength");
            this.strength.serialize(generator, mapper);
        }
        if (this.decomposition != null) {
            generator.writeKey("decomposition");
            this.decomposition.serialize(generator, mapper);
        }
        if (this.alternate != null) {
            generator.writeKey("alternate");
            this.alternate.serialize(generator, mapper);
        }
        if (this.caseLevel != null) {
            generator.writeKey("case_level");
            generator.write(this.caseLevel);
        }
        if (this.caseFirst != null) {
            generator.writeKey("case_first");
            this.caseFirst.serialize(generator, mapper);
        }
        if (this.numeric != null) {
            generator.writeKey("numeric");
            generator.write(this.numeric);
        }
        if (this.variableTop != null) {
            generator.writeKey("variable_top");
            generator.write(this.variableTop);
        }
        if (this.hiraganaQuaternaryMode != null) {
            generator.writeKey("hiragana_quaternary_mode");
            generator.write(this.hiraganaQuaternaryMode);
        }
    }

    protected static void setupIcuCollationPropertyDeserializer(ObjectDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::norms, JsonpDeserializer.booleanDeserializer(), "norms");
        op.add(Builder::indexOptions, IndexOptions._DESERIALIZER, "index_options");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::nullValue, JsonpDeserializer.stringDeserializer(), "null_value");
        op.add(Builder::rules, JsonpDeserializer.stringDeserializer(), "rules");
        op.add(Builder::language, JsonpDeserializer.stringDeserializer(), "language");
        op.add(Builder::country, JsonpDeserializer.stringDeserializer(), "country");
        op.add(Builder::variant, JsonpDeserializer.stringDeserializer(), "variant");
        op.add(Builder::strength, IcuCollationStrength._DESERIALIZER, "strength");
        op.add(Builder::decomposition, IcuCollationDecomposition._DESERIALIZER, "decomposition");
        op.add(Builder::alternate, IcuCollationAlternate._DESERIALIZER, "alternate");
        op.add(Builder::caseLevel, JsonpDeserializer.booleanDeserializer(), "case_level");
        op.add(Builder::caseFirst, IcuCollationCaseFirst._DESERIALIZER, "case_first");
        op.add(Builder::numeric, JsonpDeserializer.booleanDeserializer(), "numeric");
        op.add(Builder::variableTop, JsonpDeserializer.stringDeserializer(), "variable_top");
        op.add(Builder::hiraganaQuaternaryMode, JsonpDeserializer.booleanDeserializer(), "hiragana_quaternary_mode");
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<IcuCollationProperty> {
        @Nullable
        private Boolean norms;
        @Nullable
        private IndexOptions indexOptions;
        @Nullable
        private Boolean index;
        @Nullable
        private String nullValue;
        @Nullable
        private String rules;
        @Nullable
        private String language;
        @Nullable
        private String country;
        @Nullable
        private String variant;
        @Nullable
        private IcuCollationStrength strength;
        @Nullable
        private IcuCollationDecomposition decomposition;
        @Nullable
        private IcuCollationAlternate alternate;
        @Nullable
        private Boolean caseLevel;
        @Nullable
        private IcuCollationCaseFirst caseFirst;
        @Nullable
        private Boolean numeric;
        @Nullable
        private String variableTop;
        @Nullable
        private Boolean hiraganaQuaternaryMode;

        public final Builder norms(@Nullable Boolean value) {
            this.norms = value;
            return this;
        }

        public final Builder indexOptions(@Nullable IndexOptions value) {
            this.indexOptions = value;
            return this;
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder nullValue(@Nullable String value) {
            this.nullValue = value;
            return this;
        }

        public final Builder rules(@Nullable String value) {
            this.rules = value;
            return this;
        }

        public final Builder language(@Nullable String value) {
            this.language = value;
            return this;
        }

        public final Builder country(@Nullable String value) {
            this.country = value;
            return this;
        }

        public final Builder variant(@Nullable String value) {
            this.variant = value;
            return this;
        }

        public final Builder strength(@Nullable IcuCollationStrength value) {
            this.strength = value;
            return this;
        }

        public final Builder decomposition(@Nullable IcuCollationDecomposition value) {
            this.decomposition = value;
            return this;
        }

        public final Builder alternate(@Nullable IcuCollationAlternate value) {
            this.alternate = value;
            return this;
        }

        public final Builder caseLevel(@Nullable Boolean value) {
            this.caseLevel = value;
            return this;
        }

        public final Builder caseFirst(@Nullable IcuCollationCaseFirst value) {
            this.caseFirst = value;
            return this;
        }

        public final Builder numeric(@Nullable Boolean value) {
            this.numeric = value;
            return this;
        }

        public final Builder variableTop(@Nullable String value) {
            this.variableTop = value;
            return this;
        }

        public final Builder hiraganaQuaternaryMode(@Nullable Boolean value) {
            this.hiraganaQuaternaryMode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IcuCollationProperty build() {
            this._checkSingleUse();
            return new IcuCollationProperty(this);
        }
    }
}

