/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch._types.query_dsl.Like;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MoreLikeThisQuery
extends QueryBase
implements QueryVariant {
    @Nullable
    private final String analyzer;
    @Nullable
    private final Double boostTerms;
    @Nullable
    private final Boolean failOnUnsupportedField;
    private final List<String> fields;
    @Nullable
    private final Boolean include;
    private final List<Like> like;
    @Nullable
    private final Integer maxDocFreq;
    @Nullable
    private final Integer maxQueryTerms;
    @Nullable
    private final Integer maxWordLength;
    @Nullable
    private final Integer minDocFreq;
    @Nullable
    private final String minimumShouldMatch;
    @Nullable
    private final Integer minTermFreq;
    @Nullable
    private final Integer minWordLength;
    @Nullable
    private final String routing;
    private final List<String> stopWords;
    private final List<Like> unlike;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final JsonpDeserializer<MoreLikeThisQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MoreLikeThisQuery::setupMoreLikeThisQueryDeserializer);

    private MoreLikeThisQuery(Builder builder) {
        super(builder);
        this.analyzer = builder.analyzer;
        this.boostTerms = builder.boostTerms;
        this.failOnUnsupportedField = builder.failOnUnsupportedField;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.include = builder.include;
        this.like = ApiTypeHelper.unmodifiableRequired(builder.like, (Object)this, "like");
        this.maxDocFreq = builder.maxDocFreq;
        this.maxQueryTerms = builder.maxQueryTerms;
        this.maxWordLength = builder.maxWordLength;
        this.minDocFreq = builder.minDocFreq;
        this.minimumShouldMatch = builder.minimumShouldMatch;
        this.minTermFreq = builder.minTermFreq;
        this.minWordLength = builder.minWordLength;
        this.routing = builder.routing;
        this.stopWords = ApiTypeHelper.unmodifiable(builder.stopWords);
        this.unlike = ApiTypeHelper.unmodifiable(builder.unlike);
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public static MoreLikeThisQuery of(Function<Builder, ObjectBuilder<MoreLikeThisQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.MoreLikeThis;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    @Nullable
    public final Double boostTerms() {
        return this.boostTerms;
    }

    @Nullable
    public final Boolean failOnUnsupportedField() {
        return this.failOnUnsupportedField;
    }

    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final Boolean include() {
        return this.include;
    }

    public final List<Like> like() {
        return this.like;
    }

    @Nullable
    public final Integer maxDocFreq() {
        return this.maxDocFreq;
    }

    @Nullable
    public final Integer maxQueryTerms() {
        return this.maxQueryTerms;
    }

    @Nullable
    public final Integer maxWordLength() {
        return this.maxWordLength;
    }

    @Nullable
    public final Integer minDocFreq() {
        return this.minDocFreq;
    }

    @Nullable
    public final String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    @Nullable
    public final Integer minTermFreq() {
        return this.minTermFreq;
    }

    @Nullable
    public final Integer minWordLength() {
        return this.minWordLength;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    public final List<String> stopWords() {
        return this.stopWords;
    }

    public final List<Like> unlike() {
        return this.unlike;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (this.boostTerms != null) {
            generator.writeKey("boost_terms");
            generator.write(this.boostTerms);
        }
        if (this.failOnUnsupportedField != null) {
            generator.writeKey("fail_on_unsupported_field");
            generator.write(this.failOnUnsupportedField);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.include != null) {
            generator.writeKey("include");
            generator.write(this.include);
        }
        if (ApiTypeHelper.isDefined(this.like)) {
            generator.writeKey("like");
            generator.writeStartArray();
            for (Like like : this.like) {
                like.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxDocFreq != null) {
            generator.writeKey("max_doc_freq");
            generator.write(this.maxDocFreq);
        }
        if (this.maxQueryTerms != null) {
            generator.writeKey("max_query_terms");
            generator.write(this.maxQueryTerms);
        }
        if (this.maxWordLength != null) {
            generator.writeKey("max_word_length");
            generator.write(this.maxWordLength);
        }
        if (this.minDocFreq != null) {
            generator.writeKey("min_doc_freq");
            generator.write(this.minDocFreq);
        }
        if (this.minimumShouldMatch != null) {
            generator.writeKey("minimum_should_match");
            generator.write(this.minimumShouldMatch);
        }
        if (this.minTermFreq != null) {
            generator.writeKey("min_term_freq");
            generator.write(this.minTermFreq);
        }
        if (this.minWordLength != null) {
            generator.writeKey("min_word_length");
            generator.write(this.minWordLength);
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (ApiTypeHelper.isDefined(this.stopWords)) {
            generator.writeKey("stop_words");
            generator.writeStartArray();
            for (String string : this.stopWords) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.unlike)) {
            generator.writeKey("unlike");
            generator.writeStartArray();
            for (Like like : this.unlike) {
                like.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        if (this.versionType != null) {
            generator.writeKey("version_type");
            this.versionType.serialize(generator, mapper);
        }
    }

    protected static void setupMoreLikeThisQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::boostTerms, JsonpDeserializer.doubleDeserializer(), "boost_terms");
        op.add(Builder::failOnUnsupportedField, JsonpDeserializer.booleanDeserializer(), "fail_on_unsupported_field");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::include, JsonpDeserializer.booleanDeserializer(), "include");
        op.add(Builder::like, JsonpDeserializer.arrayDeserializer(Like._DESERIALIZER), "like");
        op.add(Builder::maxDocFreq, JsonpDeserializer.integerDeserializer(), "max_doc_freq");
        op.add(Builder::maxQueryTerms, JsonpDeserializer.integerDeserializer(), "max_query_terms");
        op.add(Builder::maxWordLength, JsonpDeserializer.integerDeserializer(), "max_word_length");
        op.add(Builder::minDocFreq, JsonpDeserializer.integerDeserializer(), "min_doc_freq");
        op.add(Builder::minimumShouldMatch, JsonpDeserializer.stringDeserializer(), "minimum_should_match");
        op.add(Builder::minTermFreq, JsonpDeserializer.integerDeserializer(), "min_term_freq");
        op.add(Builder::minWordLength, JsonpDeserializer.integerDeserializer(), "min_word_length");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing");
        op.add(Builder::stopWords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stop_words");
        op.add(Builder::unlike, JsonpDeserializer.arrayDeserializer(Like._DESERIALIZER), "unlike");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::versionType, VersionType._DESERIALIZER, "version_type");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MoreLikeThisQuery> {
        @Nullable
        private String analyzer;
        @Nullable
        private Double boostTerms;
        @Nullable
        private Boolean failOnUnsupportedField;
        @Nullable
        private List<String> fields;
        @Nullable
        private Boolean include;
        private List<Like> like;
        @Nullable
        private Integer maxDocFreq;
        @Nullable
        private Integer maxQueryTerms;
        @Nullable
        private Integer maxWordLength;
        @Nullable
        private Integer minDocFreq;
        @Nullable
        private String minimumShouldMatch;
        @Nullable
        private Integer minTermFreq;
        @Nullable
        private Integer minWordLength;
        @Nullable
        private String routing;
        @Nullable
        private List<String> stopWords;
        @Nullable
        private List<Like> unlike;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder boostTerms(@Nullable Double value) {
            this.boostTerms = value;
            return this;
        }

        public final Builder failOnUnsupportedField(@Nullable Boolean value) {
            this.failOnUnsupportedField = value;
            return this;
        }

        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder include(@Nullable Boolean value) {
            this.include = value;
            return this;
        }

        public final Builder like(List<Like> list) {
            this.like = Builder._listAddAll(this.like, list);
            return this;
        }

        public final Builder like(Like value, Like ... values) {
            this.like = Builder._listAdd(this.like, value, values);
            return this;
        }

        public final Builder like(Function<Like.Builder, ObjectBuilder<Like>> fn) {
            return this.like(fn.apply(new Like.Builder()).build(), new Like[0]);
        }

        public final Builder maxDocFreq(@Nullable Integer value) {
            this.maxDocFreq = value;
            return this;
        }

        public final Builder maxQueryTerms(@Nullable Integer value) {
            this.maxQueryTerms = value;
            return this;
        }

        public final Builder maxWordLength(@Nullable Integer value) {
            this.maxWordLength = value;
            return this;
        }

        public final Builder minDocFreq(@Nullable Integer value) {
            this.minDocFreq = value;
            return this;
        }

        public final Builder minimumShouldMatch(@Nullable String value) {
            this.minimumShouldMatch = value;
            return this;
        }

        public final Builder minTermFreq(@Nullable Integer value) {
            this.minTermFreq = value;
            return this;
        }

        public final Builder minWordLength(@Nullable Integer value) {
            this.minWordLength = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder stopWords(List<String> list) {
            this.stopWords = Builder._listAddAll(this.stopWords, list);
            return this;
        }

        public final Builder stopWords(String value, String ... values) {
            this.stopWords = Builder._listAdd(this.stopWords, value, values);
            return this;
        }

        public final Builder unlike(List<Like> list) {
            this.unlike = Builder._listAddAll(this.unlike, list);
            return this;
        }

        public final Builder unlike(Like value, Like ... values) {
            this.unlike = Builder._listAdd(this.unlike, value, values);
            return this;
        }

        public final Builder unlike(Function<Like.Builder, ObjectBuilder<Like>> fn) {
            return this.unlike(fn.apply(new Like.Builder()).build(), new Like[0]);
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MoreLikeThisQuery build() {
            this._checkSingleUse();
            return new MoreLikeThisQuery(this);
        }
    }
}

