/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class JvmClasses
implements JsonpSerializable {
    @Nullable
    private final Long currentLoadedCount;
    @Nullable
    private final Long totalLoadedCount;
    @Nullable
    private final Long totalUnloadedCount;
    public static final JsonpDeserializer<JvmClasses> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JvmClasses::setupJvmClassesDeserializer);

    private JvmClasses(Builder builder) {
        this.currentLoadedCount = builder.currentLoadedCount;
        this.totalLoadedCount = builder.totalLoadedCount;
        this.totalUnloadedCount = builder.totalUnloadedCount;
    }

    public static JvmClasses of(Function<Builder, ObjectBuilder<JvmClasses>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long currentLoadedCount() {
        return this.currentLoadedCount;
    }

    @Nullable
    public final Long totalLoadedCount() {
        return this.totalLoadedCount;
    }

    @Nullable
    public final Long totalUnloadedCount() {
        return this.totalUnloadedCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.currentLoadedCount != null) {
            generator.writeKey("current_loaded_count");
            generator.write(this.currentLoadedCount);
        }
        if (this.totalLoadedCount != null) {
            generator.writeKey("total_loaded_count");
            generator.write(this.totalLoadedCount);
        }
        if (this.totalUnloadedCount != null) {
            generator.writeKey("total_unloaded_count");
            generator.write(this.totalUnloadedCount);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupJvmClassesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentLoadedCount, JsonpDeserializer.longDeserializer(), "current_loaded_count");
        op.add(Builder::totalLoadedCount, JsonpDeserializer.longDeserializer(), "total_loaded_count");
        op.add(Builder::totalUnloadedCount, JsonpDeserializer.longDeserializer(), "total_unloaded_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<JvmClasses> {
        @Nullable
        private Long currentLoadedCount;
        @Nullable
        private Long totalLoadedCount;
        @Nullable
        private Long totalUnloadedCount;

        public final Builder currentLoadedCount(@Nullable Long value) {
            this.currentLoadedCount = value;
            return this;
        }

        public final Builder totalLoadedCount(@Nullable Long value) {
            this.totalLoadedCount = value;
            return this;
        }

        public final Builder totalUnloadedCount(@Nullable Long value) {
            this.totalUnloadedCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JvmClasses build() {
            this._checkSingleUse();
            return new JvmClasses(this);
        }
    }
}

