/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.ServiceStatus;
import org.apache.camel.StartupSummaryLevel;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.PropertiesReload;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.FileWatcherResourceReloadStrategy;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OrderedLocationProperties;
import org.apache.camel.util.OrderedProperties;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteWatcherReloadStrategy
extends FileWatcherResourceReloadStrategy {
    public static final String RELOAD_RESOURCES = "RouteWatcherReloadResources";
    private static final Logger LOG = LoggerFactory.getLogger(RouteWatcherReloadStrategy.class);
    private static final String DEFAULT_PATTERN = "*.yaml,*.xml";
    private String pattern;
    private boolean removeAllRoutes = true;
    private final List<Resource> previousSources = new ArrayList<Resource>();

    public RouteWatcherReloadStrategy() {
    }

    public RouteWatcherReloadStrategy(String directory) {
        this(directory, false);
    }

    public RouteWatcherReloadStrategy(String directory, boolean recursive) {
        super(directory, recursive);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean isRemoveAllRoutes() {
        return this.removeAllRoutes;
    }

    public void setRemoveAllRoutes(boolean removeAllRoutes) {
        this.removeAllRoutes = removeAllRoutes;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.getFolder(), "folder", this);
        if (this.pattern == null || this.pattern.isBlank()) {
            this.pattern = DEFAULT_PATTERN;
        } else if ("*".equals(this.pattern)) {
            this.pattern = "**";
        }
        String base = new File(this.getFolder()).getAbsolutePath();
        AntPathMatcher matcher = new AntPathMatcher();
        if (this.getFileFilter() == null) {
            String[] parts = this.pattern.split(",");
            this.setFileFilter(f -> {
                for (String part : parts) {
                    String name;
                    boolean exact;
                    String path = f.getAbsolutePath();
                    if (path.startsWith(base)) {
                        path = FileUtil.stripPath(path);
                    }
                    boolean result = (exact = (name = FileUtil.compactPath(f.getPath())).equals(part)) || matcher.match(part, path, false);
                    LOG.trace("Accepting file pattern:{} path:{} -> {}", new Object[]{part, path, result});
                    if (!result) continue;
                    return true;
                }
                return false;
            });
        }
        if (this.getResourceReload() == null) {
            this.setResourceReload((name, resource) -> {
                if (name.endsWith(".properties")) {
                    this.onPropertiesReload(resource, true);
                } else {
                    this.onRouteReload(List.of(resource), false);
                }
            });
        }
        super.doStart();
    }

    @Override
    protected String startupMessage(File dir) {
        return "Live route reloading enabled (directory: " + String.valueOf(dir) + ")";
    }

    protected boolean onPropertiesReload(Resource resource, boolean reloadRoutes) throws Exception {
        OrderedLocationProperties changed = null;
        PropertiesComponent pc = this.getCamelContext().getPropertiesComponent();
        PropertiesReload pr = this.getCamelContext().hasService(PropertiesReload.class);
        if (pr != null) {
            InputStream is = resource.getInputStream();
            OrderedProperties tmp = new OrderedProperties();
            tmp.load(is);
            IOHelper.close((Closeable)is);
            changed = new OrderedLocationProperties();
            changed.putAll(resource.getLocation(), tmp);
            pc.keepOnlyChangeProperties(changed);
        }
        boolean reloaded = false;
        if (changed != null && !changed.isEmpty()) {
            LOG.info("Reloading properties: {}. (Only Camel routes and components can be updated with changes)", (Object)resource.getLocation());
            reloaded = pc.reloadProperties(resource.getLocation());
            if (reloaded) {
                pr.onReload(resource.getLocation(), changed);
                if (reloadRoutes) {
                    this.onRouteReload(null, false);
                }
            } else {
                String existing = this.getPropertiesByLocation(resource.getLocation());
                if (existing == null) {
                    String loc = resource.getLocation();
                    if (loc.contains(":")) {
                        loc = StringHelper.after(loc, ":");
                    }
                    PropertiesSource ps = pc.getPropertiesSourceFactory().newFilePropertiesSource(loc);
                    pc.addPropertiesSource(ps);
                    reloaded = true;
                }
            }
        }
        return reloaded;
    }

    private String getPropertiesByLocation(String loc) {
        PropertiesComponent pc = this.getCamelContext().getPropertiesComponent();
        for (String s2 : pc.getLocations()) {
            if (s2.endsWith(";optional=true")) {
                s2 = s2.substring(0, s2.length() - 14);
            }
            if (!Objects.equals(s2, loc)) continue;
            return loc;
        }
        return null;
    }

    protected void onRouteReload(Collection<Resource> resources, boolean removeEverything) {
        ArrayList<Resource> sources = new ArrayList<Resource>();
        if (!this.previousSources.isEmpty()) {
            this.previousSources.forEach(rs -> {
                if (rs != null && !RouteWatcherReloadStrategy.equalResourceLocation(resources, rs)) {
                    sources.add((Resource)rs);
                }
            });
        }
        try {
            Route route;
            int total;
            Collection extras;
            if (this.removeAllRoutes) {
                this.getCamelContext().getRoutes().forEach(r -> {
                    Resource rs = r.getSourceResource();
                    if (rs != null && !RouteWatcherReloadStrategy.equalResourceLocation(resources, rs)) {
                        sources.add(rs);
                    }
                });
                this.getCamelContext().getRouteController().removeAllRoutes();
                this.getCamelContext().removeRouteTemplates("*");
                this.getCamelContext().getEndpointRegistry().clear();
            }
            if (resources != null) {
                for (Resource resource : resources) {
                    if (!Files.exists(Paths.get(resource.getURI()), new LinkOption[0])) continue;
                    sources.add(resource);
                }
            }
            if ((extras = this.getCamelContext().getRegistry().lookupByNameAndType(RELOAD_RESOURCES, Collection.class)) != null) {
                for (Resource extra : extras) {
                    if (sources.contains(extra)) continue;
                    sources.add(extra);
                }
            }
            this.previousSources.clear();
            this.previousSources.addAll(sources);
            if (removeEverything) {
                sources.clear();
            }
            Set<String> set = PluginHelper.getRoutesLoader(this.getCamelContext()).updateRoutes(sources);
            this.previousSources.clear();
            if (!set.isEmpty()) {
                ArrayList<String> lines = new ArrayList<String>();
                total = 0;
                int started = 0;
                for (String id : set) {
                    ++total;
                    route = this.getCamelContext().getRoute(id);
                    if (route == null) continue;
                    ServiceStatus status = this.getCamelContext().getRouteController().getRouteStatus(id);
                    if (status == null) {
                        LOG.warn("Cannot get route status for route: {}. This route is skipped.", (Object)id);
                        continue;
                    }
                    if (ServiceStatus.Started.equals(status)) {
                        ++started;
                    }
                    String uri = route.getEndpoint().getEndpointBaseUri();
                    uri = URISupport.sanitizeUri(uri);
                    String loc = route.getSourceLocationShort();
                    if (loc == null) {
                        loc = "";
                    }
                    lines.add(String.format("    %s %s (%s) (source: %s)", status, id, uri, loc));
                }
                LOG.info("Routes reloaded summary (total:{} started:{})", (Object)total, (Object)started);
                if (this.getCamelContext().getStartupSummaryLevel() == StartupSummaryLevel.Default || this.getCamelContext().getStartupSummaryLevel() == StartupSummaryLevel.Verbose) {
                    for (String line : lines) {
                        LOG.info(line);
                    }
                }
            }
            int index = 1;
            total = set.size();
            for (String id : set) {
                Route route2 = this.getCamelContext().getRoute(id);
                if (route2 == null) continue;
                EventHelper.notifyRouteReloaded(this.getCamelContext(), route2, index++, total);
            }
            if (!this.removeAllRoutes) {
                StringJoiner sj = new StringJoiner("\n    ");
                for (String id : set) {
                    route = this.getCamelContext().getRoute(id);
                    if (route == null || route.isCustomId()) continue;
                    sj.add(route.getEndpoint().getEndpointUri());
                }
                if (sj.length() > 0) {
                    LOG.warn("Routes with no id's detected. Its recommended to assign route id's to your routes so Camel can reload the routes correctly.\n    Unassigned routes:\n    {}", (Object)sj);
                }
            }
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeException(e);
        }
    }

    private static boolean equalResourceLocation(Collection<Resource> sources, Resource target) {
        if (sources == null || target == null || sources.isEmpty()) {
            return false;
        }
        for (Resource source : sources) {
            if (!RouteWatcherReloadStrategy.equalResourceLocation(source, target)) continue;
            return true;
        }
        return false;
    }

    private static boolean equalResourceLocation(Resource source, Resource target) {
        URI u2;
        if (source == null || target == null) {
            return false;
        }
        URI u1 = source.getURI();
        boolean answer = u1.equals(u2 = target.getURI());
        if (!answer) {
            String s1 = u1.toString().replace("src/main/resources/", "").replace("src/test/resources/", "").replace("target/classes/", "");
            String s2 = u2.toString().replace("src/main/resources/", "").replace("src/test/resources/", "").replace("target/classes/", "");
            answer = s1.equals(s2);
        }
        return answer;
    }
}

