/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd3;

import java.util.Map;
import java.util.Optional;
import org.apache.camel.Endpoint;
import org.apache.camel.component.etcd3.Etcd3Configuration;
import org.apache.camel.component.etcd3.Etcd3Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@Component(value="etcd3")
public class Etcd3Component
extends DefaultComponent {
    @Metadata
    private Etcd3Configuration configuration = new Etcd3Configuration();

    public Etcd3Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Etcd3Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String path;
        String string = path = ObjectHelper.isEmpty(remaining) ? "/" : remaining;
        if (!path.startsWith("/")) {
            path = String.format("/%s", path);
        }
        Etcd3Endpoint endpoint = new Etcd3Endpoint(uri, this, this.loadConfiguration(), path);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    private Etcd3Configuration loadConfiguration() {
        return Optional.ofNullable(this.configuration).orElseGet(Etcd3Configuration::new).copy();
    }
}

