/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd3;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.component.etcd3.Etcd3Configuration;
import org.apache.camel.component.etcd3.Etcd3Endpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.util.StringHelper;

class Etcd3Producer
extends DefaultAsyncProducer {
    private final Etcd3Configuration configuration;
    private final String path;
    private final Client client;
    private final KV kvClient;
    private final Charset defaultKeyCharset;
    private final Charset defaultValueCharset;

    Etcd3Producer(Etcd3Endpoint endpoint, Etcd3Configuration configuration, String path) {
        super(endpoint);
        this.configuration = configuration;
        this.path = path;
        this.client = configuration.createClient();
        this.kvClient = this.client.getKVClient();
        this.defaultKeyCharset = Charset.forName(configuration.getKeyCharset());
        this.defaultValueCharset = Charset.forName(configuration.getValueCharset());
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            String action = exchange.getIn().getHeader("CamelEtcdAction", String.class);
            String targetPath = exchange.getIn().getHeader("CamelEtcdPath", String.class);
            if (targetPath == null) {
                targetPath = this.path;
            }
            StringHelper.notEmpty(targetPath, "CamelEtcdPath");
            StringHelper.notEmpty(action, "CamelEtcdAction");
            switch (action) {
                case "set": {
                    this.processSetAsync(targetPath, exchange, callback);
                    break;
                }
                case "get": {
                    this.processGetAsync(targetPath, exchange, callback);
                    break;
                }
                case "delete": {
                    this.processDelAsync(targetPath, exchange, callback);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown action " + action);
                }
            }
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        return false;
    }

    @Override
    protected void doStop() throws Exception {
        try {
            this.client.close();
        }
        finally {
            super.doStop();
        }
    }

    private <T> void onComplete(CompletableFuture<T> future, Exchange exchange, AsyncCallback callback) {
        ((CompletableFuture)future.thenAccept(r -> exchange.getIn().setBody(r))).whenComplete((r, e) -> {
            try {
                if (e != null) {
                    exchange.setException(new CamelExchangeException("An error occurred while executing the action", exchange, (Throwable)e));
                }
            }
            finally {
                callback.done(false);
            }
        });
    }

    private void processDelAsync(String targetPath, Exchange exchange, AsyncCallback callback) {
        this.onComplete(this.kvClient.delete(ByteSequence.from(targetPath, this.getKeyCharset(exchange)), DeleteOption.newBuilder().isPrefix(this.isPrefix(exchange)).build()), exchange, callback);
    }

    private void processGetAsync(String targetPath, Exchange exchange, AsyncCallback callback) {
        this.onComplete(this.kvClient.get(ByteSequence.from(targetPath, this.getKeyCharset(exchange)), GetOption.newBuilder().isPrefix(this.isPrefix(exchange)).build()), exchange, callback);
    }

    private void processSetAsync(String targetPath, Exchange exchange, AsyncCallback callback) {
        this.onComplete(this.kvClient.put(ByteSequence.from(targetPath, this.getKeyCharset(exchange)), ByteSequence.from(exchange.getIn().getBody(String.class), this.getValueCharset(exchange))), exchange, callback);
    }

    private boolean isPrefix(Exchange exchange) {
        Boolean isPrefix = exchange.getIn().getHeader("CamelEtcdIsPrefix", Boolean.class);
        return isPrefix == null ? this.configuration.isPrefix() : isPrefix.booleanValue();
    }

    private Charset getKeyCharset(Exchange exchange) {
        String charset = exchange.getIn().getHeader("CamelEtcdKeyCharset", String.class);
        return charset == null ? this.defaultKeyCharset : Charset.forName(charset);
    }

    private Charset getValueCharset(Exchange exchange) {
        String charset = exchange.getIn().getHeader("CamelEtcdValueCharset", String.class);
        return charset == null ? this.defaultValueCharset : Charset.forName(charset);
    }
}

