/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.exec;

import org.apache.camel.Exchange;
import org.apache.camel.component.exec.ExecCommand;
import org.apache.camel.component.exec.ExecEndpoint;
import org.apache.camel.component.exec.ExecResult;
import org.apache.camel.spi.Metadata;

public interface ExecBinding {
    @Metadata(label="in", description="The name of the system command that will be executed. Overrides\n`executable` in the URI.", javaType="String")
    public static final String EXEC_COMMAND_EXECUTABLE = "CamelExecCommandExecutable";
    @Metadata(label="in", description="Command-line argument(s) to pass to the executed process. The argument(s)\nis/are used literally - no quoting is applied. Overrides any existing\n`args` in the URI.", javaType="java.util.List<String> or String")
    public static final String EXEC_COMMAND_ARGS = "CamelExecCommandArgs";
    @Metadata(label="in", description="The name of a file, created by the executable, that should be considered\nas its output. Overrides any existing `outFile` in the URI.", javaType="String")
    public static final String EXEC_COMMAND_OUT_FILE = "CamelExecCommandOutFile";
    @Metadata(label="in", description="The directory in which the command should be executed. Overrides any\nexisting `workingDir` in the URI.", javaType="String")
    public static final String EXEC_COMMAND_WORKING_DIR = "CamelExecCommandWorkingDir";
    @Metadata(label="in", description="The timeout, in milliseconds, after which the executable should be\nterminated. Overrides any existing `timeout` in the URI.", javaType="long")
    public static final String EXEC_COMMAND_TIMEOUT = "CamelExecCommandTimeout";
    @Metadata(label="in", description="The exit values for successful execution of the process.\nOverrides any existing `exitValues` in the URI.", javaType="String")
    public static final String EXEC_COMMAND_EXIT_VALUES = "CamelExecExitValues";
    @Metadata(label="out", description="The value of this header points to the standard error stream (stderr) of\nthe executable. If no stderr is written, the value is `null`.", javaType="java.io.InputStream")
    public static final String EXEC_STDERR = "CamelExecStderr";
    @Metadata(label="out", description="The value of this header is the _exit value_ of the executable. Non-zero\nexit values typically indicate abnormal termination. Note that the exit\nvalue is OS-dependent.", javaType="int")
    public static final String EXEC_EXIT_VALUE = "CamelExecExitValue";
    @Metadata(label="in", description="Indicates that when `stdout` is empty, this component will populate the\nCamel Message Body with `stderr`. This behavior is disabled (`false`) by\ndefault.", javaType="boolean")
    public static final String EXEC_USE_STDERR_ON_EMPTY_STDOUT = "CamelExecUseStderrOnEmptyStdout";
    @Metadata(label="in", description="Logging level to be used for commands during execution. The default value is DEBUG.\nPossible values are TRACE, DEBUG, INFO, WARN, ERROR or OFF (Values of LoggingLevel enum)", javaType="String")
    public static final String EXEC_COMMAND_LOG_LEVEL = "CamelExecCommandLogLevel";

    public ExecCommand readInput(Exchange var1, ExecEndpoint var2);

    public void writeOutput(Exchange var1, ExecResult var2);
}

