/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.odps;

import com.aliyun.odps.io.Writable;
import com.aliyun.odps.io.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class JSONWritable
implements Writable {
    private static final byte[] EMPTY_BYTES = new byte[0];
    byte[] bytes;
    int off;
    int length;

    public JSONWritable() {
        this.bytes = EMPTY_BYTES;
    }

    public JSONWritable(byte[] bytes) {
        this.bytes = bytes;
        this.off = 0;
        this.length = bytes.length;
    }

    public void write(DataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)this.length);
        out.write(this.bytes, this.off, this.length);
    }

    public void readFields(DataInput in) throws IOException {
        int newLength = WritableUtils.readVInt((DataInput)in);
        this.setCapacity(newLength, false);
        in.readFully(this.bytes, 0, newLength);
        this.length = newLength;
    }

    void setCapacity(int len, boolean keepData) {
        if (this.bytes == null || this.bytes.length < len) {
            byte[] newBytes = new byte[len];
            if (this.bytes != null && keepData) {
                System.arraycopy(this.bytes, 0, newBytes, 0, this.length);
            }
            this.bytes = newBytes;
        }
    }

    public void set(String string) {
        this.bytes = string.getBytes(StandardCharsets.UTF_8);
        this.length = this.bytes.length;
    }

    public void set(byte[] utf8) {
        this.set(utf8, 0, utf8.length);
    }

    public void set(byte[] utf8, int start, int len) {
        this.setCapacity(len, false);
        System.arraycopy(utf8, start, this.bytes, 0, len);
        this.length = len;
    }

    public String toString() {
        return new String(this.bytes, this.off, this.length, StandardCharsets.UTF_8);
    }
}

