/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.properties;

import org.apache.camel.util.StringHelper;

public final class PropertiesLocation {
    private final String resolver;
    private final String path;
    private final boolean optional;

    public PropertiesLocation(String location) {
        location = location.trim();
        int idx = location.indexOf(58);
        if (idx != -1) {
            this.resolver = location.substring(0, idx);
            location = location.substring(idx + 1);
        } else {
            this.resolver = "classpath";
        }
        idx = location.lastIndexOf(59);
        if (idx != -1) {
            this.optional = StringHelper.after(location.substring(idx + 1), "optional=", Boolean::valueOf).orElse(false);
            location = location.substring(0, idx);
        } else {
            this.optional = false;
        }
        this.path = location;
    }

    public PropertiesLocation(String resolver, String path) {
        this(resolver, path, false);
    }

    public PropertiesLocation(String resolver, String path, Boolean optional) {
        this.resolver = resolver;
        this.path = path;
        this.optional = optional;
    }

    public String getResolver() {
        return this.resolver;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertiesLocation location = (PropertiesLocation)o;
        if (this.optional != location.optional) {
            return false;
        }
        if (this.resolver != null ? !this.resolver.equals(location.resolver) : location.resolver != null) {
            return false;
        }
        return this.path != null ? this.path.equals(location.path) : location.path == null;
    }

    public int hashCode() {
        int result = this.resolver != null ? this.resolver.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.optional ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.resolver + ":" + this.path + (this.optional ? ";optional=true" : "");
    }
}

