/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

public class DataError {
    private final String errorDesc;
    private final int lineNo;
    private final int errorLevel;
    private final String rawData;
    private final String lastColumnName;
    private final String lastColumnValue;

    public DataError(String errorDesc, int lineNo, int errorLevel) {
        this(errorDesc, lineNo, errorLevel, null, null, null);
    }

    public DataError(String errorDesc, int lineNo, int errorLevel, String rawData) {
        this(errorDesc, lineNo, errorLevel, rawData, null, null);
    }

    public DataError(String errorDesc, int lineNo, int errorLevel, String rawData, String lastColumnName, String lastColumnValue) {
        this.errorDesc = errorDesc;
        this.lineNo = lineNo;
        this.errorLevel = errorLevel;
        this.rawData = rawData;
        this.lastColumnName = lastColumnName;
        this.lastColumnValue = lastColumnValue;
    }

    public String getErrorDesc() {
        return this.errorDesc;
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Line:").append(this.lineNo).append(" Level:").append(this.errorLevel).append(" Desc:").append(this.errorDesc).append(System.getProperty("line.separator"));
        if (this.rawData != null) {
            buf.append("RawData:").append(this.rawData).append(System.lineSeparator());
        }
        if (this.lastColumnName != null) {
            buf.append("LastColName:").append(this.lastColumnName).append(" Value:").append(this.lastColumnValue).append(System.lineSeparator());
        }
        return buf.toString();
    }

    public String getLastColumnName() {
        return this.lastColumnName;
    }

    public String getLastColumnValue() {
        return this.lastColumnValue;
    }

    public String getRawData() {
        return this.rawData;
    }
}

