/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.xml.XMLRecordElement;

public class MetaData {
    private List<ColumnMetaData> columnsNames;
    private Map columnIndexMap;
    private final Map<String, XMLRecordElement> xmlRecordElements;

    public MetaData(List<ColumnMetaData> columnNames, Map columnIndexMap) {
        this.columnsNames = Collections.unmodifiableList(columnNames);
        this.columnIndexMap = Collections.unmodifiableMap(columnIndexMap);
        this.xmlRecordElements = new HashMap<String, XMLRecordElement>();
    }

    MetaData(List<ColumnMetaData> columnNames, Map columnIndexMap, Map<String, XMLRecordElement> xmlRecordElements) {
        this.columnsNames = Collections.unmodifiableList(columnNames);
        this.columnIndexMap = columnIndexMap;
        this.xmlRecordElements = xmlRecordElements;
    }

    public List<ColumnMetaData> getColumnsNames() {
        return this.columnsNames;
    }

    public Map getColumnIndexMap() {
        return this.columnIndexMap;
    }

    public void setColumnIndexMap(Map columnIndexMap) {
        this.columnIndexMap = columnIndexMap;
    }

    public void setColumnsNames(List<ColumnMetaData> columnsNames) {
        this.columnsNames = Collections.unmodifiableList(columnsNames);
    }

    public boolean isAnyRecordFormatSpecified() {
        return this.xmlRecordElements != null && !this.xmlRecordElements.isEmpty();
    }

    public Iterator<Map.Entry<String, XMLRecordElement>> xmlRecordIterator() {
        return this.xmlRecordElements.entrySet().iterator();
    }

    public List<ColumnMetaData> getListColumnsForRecord(String key) {
        return this.xmlRecordElements.get(key).getColumns();
    }

    public int getColumnIndex(String key, String columnName) {
        Integer i;
        int idx = -1;
        if (key != null && !key.equals("detail") && !key.equals("colIndex")) {
            idx = this.xmlRecordElements.get(key).getColumnIndex(columnName);
        } else if ((key == null || key.equals("detail")) && (i = (Integer)this.columnIndexMap.get(columnName)) != null) {
            idx = i;
        }
        return idx;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Col Names:").append(this.columnsNames).append(System.lineSeparator());
        buf.append("Col Index Map:").append(this.columnIndexMap).append(System.lineSeparator());
        buf.append("XML Record Elements:").append(this.xmlRecordElements).append(System.lineSeparator());
        return buf.toString();
    }
}

