/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.BeanScope;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.BeanProcessorFactory;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.support.PluginHelper;

public class BeanReifier
extends ProcessorReifier<BeanDefinition> {
    public BeanReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (BeanDefinition)BeanDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor answer;
        Object bean = ((BeanDefinition)this.definition).getBean();
        String ref = this.parseString(((BeanDefinition)this.definition).getRef());
        String method = this.parseString(((BeanDefinition)this.definition).getMethod());
        String beanType = this.parseString(((BeanDefinition)this.definition).getBeanType());
        Class<?> beanClass = ((BeanDefinition)this.definition).getBeanClass();
        BeanProcessorFactory fac = PluginHelper.getBeanProcessorFactory(this.camelContext);
        BeanScope scope = BeanScope.Singleton;
        if (((BeanDefinition)this.definition).getScope() != null) {
            scope = this.parse(BeanScope.class, ((BeanDefinition)this.definition).getScope());
        }
        if ((answer = fac.createBeanProcessor(this.camelContext, bean, beanType, beanClass, ref, method, scope)) instanceof IdAware) {
            IdAware idAware = (IdAware)((Object)answer);
            String id = this.camelContext.getCamelContextExtension().getContextPlugin(NodeIdFactory.class).createId(this.definition);
            idAware.setId(id);
        }
        return answer;
    }
}

