/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.writer;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.flatpack.structure.ColumnMetaData;
import net.sf.flatpack.writer.AbstractWriter;
import net.sf.flatpack.writer.Writer;
import net.sf.flatpack.writer.WriterOptions;

public class DelimiterWriter
extends AbstractWriter {
    private final char delimiter;
    private final char qualifier;
    private final String replaceCarriageReturnWith;
    private List<String> columnTitles = null;
    private boolean columnTitlesWritten = false;

    protected DelimiterWriter(Map columnMapping, java.io.Writer output, char delimiter, char qualifier, WriterOptions options) throws IOException {
        super(output);
        this.delimiter = delimiter;
        this.qualifier = qualifier;
        this.lineSeparator = options.getLineSeparator();
        this.replaceCarriageReturnWith = options.getReplaceCarriageReturnWith();
        this.columnTitles = new ArrayList<String>();
        List columns = (List)columnMapping.get("detail");
        for (ColumnMetaData cmd : columns) {
            this.columnTitles.add(cmd.getColName());
        }
        if (options.isAutoPrintHeader()) {
            this.printHeader();
        }
    }

    protected void writeWithDelimiter(Object value) throws IOException {
        this.write(value);
        this.write(this.delimiter);
    }

    @Override
    protected void write(Object value) throws IOException {
        boolean needsQuoting;
        String stringValue = this.toString(value);
        boolean foundQualifier = this.qualifier != '\u0000' && stringValue.indexOf(this.qualifier) != -1;
        boolean bl = needsQuoting = stringValue.indexOf(this.delimiter) != -1 || foundQualifier || stringValue.indexOf(10) != -1;
        if (needsQuoting) {
            super.write(this.qualifier);
        }
        if (foundQualifier) {
            char[] chars;
            for (char character : chars = stringValue.toCharArray()) {
                if (character == this.qualifier) {
                    super.write(this.qualifier);
                }
                super.write(character);
            }
        } else {
            super.write(stringValue);
        }
        if (needsQuoting) {
            super.write(this.qualifier);
        }
    }

    private String toString(Object value) {
        String stringValue = "";
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            stringValue = bd.signum() == 0 ? "0" : bd.toPlainString();
        } else if (value != null) {
            stringValue = value.toString();
        }
        if (this.replaceCarriageReturnWith != null) {
            stringValue = stringValue.replaceAll("\r\n", this.replaceCarriageReturnWith).replaceAll("\n", this.replaceCarriageReturnWith);
        }
        return stringValue;
    }

    protected void writeColumnTitles() throws IOException {
        Iterator<String> titleIter = this.columnTitles.iterator();
        while (titleIter.hasNext()) {
            String title = titleIter.next();
            if (titleIter.hasNext()) {
                this.writeWithDelimiter(title);
                continue;
            }
            this.write(title);
        }
    }

    protected void writeRow() throws IOException {
        Iterator<String> titlesIter = this.columnTitles.iterator();
        while (titlesIter.hasNext()) {
            String columnTitle = titlesIter.next();
            if (this.getRowMap() == null) continue;
            if (titlesIter.hasNext()) {
                this.writeWithDelimiter(this.getRowMap().get(columnTitle));
                continue;
            }
            this.write(this.getRowMap().get(columnTitle));
        }
    }

    @Override
    public final Writer nextRecord() throws IOException {
        this.writeRow();
        return super.nextRecord();
    }

    @Override
    public Writer printFooter() throws IOException {
        return this;
    }

    @Override
    public Writer printHeader() throws IOException {
        if (!this.columnTitlesWritten) {
            this.writeColumnTitles();
            this.columnTitlesWritten = true;
            return super.nextRecord();
        }
        return this;
    }

    @Override
    protected boolean validateColumnTitle(String columnTitle) {
        return this.columnTitles.contains(columnTitle);
    }
}

