/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.FilePathResolver;
import org.apache.camel.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamCachingStrategy
extends ServiceSupport
implements CamelContextAware,
StreamCachingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultStreamCachingStrategy.class);
    private CamelContext camelContext;
    private boolean enabled;
    private String allowClassNames;
    private String denyClassNames;
    private Collection<Class<?>> allowClasses;
    private Collection<Class<?>> denyClasses;
    private boolean spoolEnabled;
    private File spoolDirectory;
    private transient String spoolDirectoryName = "${java.io.tmpdir}/camel/camel-tmp-#uuid#";
    private long spoolThreshold = 131072L;
    private int spoolUsedHeapMemoryThreshold;
    private StreamCachingStrategy.SpoolUsedHeapMemoryLimit spoolUsedHeapMemoryLimit;
    private String spoolCipher;
    private int bufferSize = 16384;
    private boolean removeSpoolDirectoryWhenStopping = true;
    private final UtilizationStatistics statistics = new UtilizationStatistics();
    private final Set<StreamCachingStrategy.SpoolRule> spoolRules = new LinkedHashSet<StreamCachingStrategy.SpoolRule>();
    private boolean anySpoolRules;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public Collection<Class<?>> getAllowClasses() {
        return this.allowClasses;
    }

    @Override
    public void setAllowClasses(Class<?> ... allowClasses) {
        this.allowClasses = List.of(allowClasses);
    }

    @Override
    public void setAllowClasses(String names) {
        this.allowClassNames = names;
    }

    @Override
    public Collection<Class<?>> getDenyClasses() {
        return this.denyClasses;
    }

    @Override
    public void setDenyClasses(Class<?> ... denyClasses) {
        this.denyClasses = List.of(denyClasses);
    }

    @Override
    public void setDenyClasses(String names) {
        this.denyClassNames = names;
    }

    @Override
    public boolean isSpoolEnabled() {
        return this.spoolEnabled;
    }

    @Override
    public void setSpoolEnabled(boolean spoolEnabled) {
        this.spoolEnabled = spoolEnabled;
    }

    @Override
    public void setSpoolDirectory(String path) {
        this.spoolDirectoryName = path;
    }

    @Override
    public void setSpoolDirectory(File path) {
        this.spoolDirectory = path;
    }

    @Override
    public File getSpoolDirectory() {
        return this.spoolDirectory;
    }

    @Override
    public long getSpoolThreshold() {
        return this.spoolThreshold;
    }

    @Override
    public int getSpoolUsedHeapMemoryThreshold() {
        return this.spoolUsedHeapMemoryThreshold;
    }

    @Override
    public void setSpoolUsedHeapMemoryThreshold(int spoolHeapMemoryWatermarkThreshold) {
        this.spoolUsedHeapMemoryThreshold = spoolHeapMemoryWatermarkThreshold;
    }

    @Override
    public StreamCachingStrategy.SpoolUsedHeapMemoryLimit getSpoolUsedHeapMemoryLimit() {
        return this.spoolUsedHeapMemoryLimit;
    }

    @Override
    public void setSpoolUsedHeapMemoryLimit(StreamCachingStrategy.SpoolUsedHeapMemoryLimit spoolUsedHeapMemoryLimit) {
        this.spoolUsedHeapMemoryLimit = spoolUsedHeapMemoryLimit;
    }

    @Override
    public void setSpoolThreshold(long spoolThreshold) {
        this.spoolThreshold = spoolThreshold;
    }

    @Override
    public String getSpoolCipher() {
        return this.spoolCipher;
    }

    @Override
    public void setSpoolCipher(String spoolCipher) {
        this.spoolCipher = spoolCipher;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean isRemoveSpoolDirectoryWhenStopping() {
        return this.removeSpoolDirectoryWhenStopping;
    }

    @Override
    public void setRemoveSpoolDirectoryWhenStopping(boolean removeSpoolDirectoryWhenStopping) {
        this.removeSpoolDirectoryWhenStopping = removeSpoolDirectoryWhenStopping;
    }

    @Override
    public boolean isAnySpoolRules() {
        return this.anySpoolRules;
    }

    @Override
    public void setAnySpoolRules(boolean anySpoolTasks) {
        this.anySpoolRules = anySpoolTasks;
    }

    @Override
    public StreamCachingStrategy.Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public boolean shouldSpoolCache(long length) {
        if (!this.enabled || this.spoolRules.isEmpty()) {
            return false;
        }
        boolean all = true;
        boolean any = false;
        for (StreamCachingStrategy.SpoolRule rule : this.spoolRules) {
            boolean result = rule.shouldSpoolCache(length);
            if (!result) {
                all = false;
                if (this.anySpoolRules) continue;
                break;
            }
            any = true;
            if (!this.anySpoolRules) continue;
            break;
        }
        boolean answer = this.anySpoolRules ? any : all;
        LOG.debug("Should spool cache {} -> {}", (Object)length, (Object)answer);
        return answer;
    }

    @Override
    public void addSpoolRule(StreamCachingStrategy.SpoolRule rule) {
        this.spoolRules.add(rule);
    }

    @Override
    public StreamCache cache(Exchange exchange) {
        return this.doCache(exchange.getMessage().getBody(), exchange);
    }

    @Override
    public StreamCache cache(Message message) {
        return this.doCache(message.getBody(), message.getExchange());
    }

    @Override
    public StreamCache cache(Object body) {
        return this.doCache(body, null);
    }

    private StreamCache doCache(Object body, Exchange exchange) {
        StreamCache cache = null;
        if (body != null) {
            boolean allowed;
            boolean bl = allowed = this.allowClasses == null && this.denyClasses == null;
            if (!allowed) {
                allowed = this.checkAllowDenyList(body);
            }
            if (allowed) {
                cache = exchange != null ? this.camelContext.getTypeConverter().convertTo(StreamCache.class, exchange, body) : this.camelContext.getTypeConverter().convertTo(StreamCache.class, body);
            }
        }
        if (cache != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Cached stream to {} -> {}", (Object)(cache.inMemory() ? "memory" : "spool"), (Object)cache);
            }
            if (this.statistics.isStatisticsEnabled()) {
                this.computeStatistics(cache);
            }
        }
        return cache;
    }

    private boolean checkAllowDenyList(Object body) {
        boolean allowed;
        Class<?> source = body.getClass();
        if (this.denyClasses != null && this.allowClasses != null) {
            boolean bl = allowed = !DefaultStreamCachingStrategy.isAssignableFrom(source, this.denyClasses);
            if (allowed) {
                allowed = DefaultStreamCachingStrategy.isAssignableFrom(source, this.allowClasses);
            }
        } else {
            allowed = this.denyClasses != null ? !DefaultStreamCachingStrategy.isAssignableFrom(source, this.denyClasses) : DefaultStreamCachingStrategy.isAssignableFrom(source, this.allowClasses);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Cache stream from class: {} is {}", source, (Object)(allowed ? "allowed" : "denied"));
        }
        return allowed;
    }

    private void computeStatistics(StreamCache cache) {
        try {
            if (cache.inMemory()) {
                this.statistics.updateMemory(cache.length());
            } else {
                this.statistics.updateSpool(cache.length());
            }
        }
        catch (Exception e) {
            LOG.debug("Error updating cache statistics. This exception is ignored.", (Throwable)e);
        }
    }

    protected static boolean isAssignableFrom(Class<?> source, Collection<Class<?>> targets) {
        for (Class<?> target : targets) {
            if (!target.isAssignableFrom(source)) continue;
            return true;
        }
        return false;
    }

    protected String resolveSpoolDirectory(String path) {
        if (this.camelContext.getManagementNameStrategy() != null) {
            String name = this.camelContext.getManagementNameStrategy().resolveManagementName(path, this.camelContext.getName(), false);
            if (name != null) {
                name = this.customResolveManagementName(name);
            }
            if (name != null) {
                name = this.camelContext.getManagementNameStrategy().resolveManagementName(name, this.camelContext.getName(), true);
            }
            return name;
        }
        return this.defaultManagementName(path);
    }

    protected String defaultManagementName(String path) {
        String name = this.camelContext.getName();
        String answer = path;
        answer = answer.replace("#camelId#", name);
        answer = answer.replace("#name#", name);
        answer = this.customResolveManagementName(answer);
        return answer;
    }

    protected String customResolveManagementName(String pattern) {
        if (pattern.contains("#uuid#")) {
            String uuid = this.camelContext.getUuidGenerator().generateUuid();
            pattern = pattern.replace("#uuid#", uuid);
        }
        return FilePathResolver.resolvePath(pattern);
    }

    @Override
    protected void doStart() throws Exception {
        Class<?> clazz;
        if (!this.enabled) {
            LOG.debug("StreamCaching is not enabled");
            return;
        }
        if (this.allowClassNames != null) {
            if (this.allowClasses == null) {
                this.allowClasses = new ArrayList();
            }
            for (String name : this.allowClassNames.split(",")) {
                name = name.trim();
                clazz = this.camelContext.getClassResolver().resolveMandatoryClass(name);
                this.allowClasses.add(clazz);
            }
        }
        if (this.denyClassNames != null) {
            if (this.denyClasses == null) {
                this.denyClasses = new ArrayList();
            }
            for (String name : this.denyClassNames.split(",")) {
                name = name.trim();
                clazz = this.camelContext.getClassResolver().resolveMandatoryClass(name);
                this.denyClasses.add(clazz);
            }
        }
        if (this.spoolUsedHeapMemoryThreshold > 99) {
            throw new IllegalArgumentException("SpoolHeapMemoryWatermarkThreshold must not be higher than 99, was: " + this.spoolUsedHeapMemoryThreshold);
        }
        if (this.spoolEnabled && (this.spoolThreshold > 0L || this.spoolUsedHeapMemoryThreshold > 0)) {
            if (this.spoolDirectory == null && this.spoolDirectoryName == null) {
                throw new IllegalArgumentException("SpoolDirectory must be configured when using SpoolThreshold > 0");
            }
            if (this.spoolDirectory == null) {
                String name = this.resolveSpoolDirectory(this.spoolDirectoryName);
                if (name != null) {
                    this.spoolDirectory = new File(name);
                    this.spoolDirectoryName = null;
                } else {
                    throw new IllegalStateException("Cannot resolve spool directory from pattern: " + this.spoolDirectoryName);
                }
            }
            if (this.spoolDirectory.exists()) {
                if (this.spoolDirectory.isDirectory()) {
                    LOG.debug("Using spool directory: {}", (Object)this.spoolDirectory);
                } else {
                    LOG.warn("Spool directory: {} is not a directory. This may cause problems spooling to disk for the stream caching!", (Object)this.spoolDirectory);
                }
            } else {
                boolean created = this.spoolDirectory.mkdirs();
                if (!created) {
                    LOG.warn("Cannot create spool directory: {}. This may cause problems spooling to disk for the stream caching!", (Object)this.spoolDirectory);
                } else {
                    LOG.debug("Created spool directory: {}", (Object)this.spoolDirectory);
                }
            }
            if (this.spoolThreshold > 0L) {
                this.spoolRules.add(new FixedThresholdSpoolRule());
            }
            if (this.spoolUsedHeapMemoryThreshold > 0) {
                if (this.spoolUsedHeapMemoryLimit == null) {
                    this.spoolUsedHeapMemoryLimit = StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Max;
                }
                this.spoolRules.add(new UsedHeapMemorySpoolRule(this.spoolUsedHeapMemoryLimit));
            }
        }
        LOG.debug("StreamCaching configuration {}", (Object)this);
        if (this.spoolDirectory != null) {
            LOG.info("StreamCaching in use with spool directory: {} and rules: {}", (Object)this.spoolDirectory.getPath(), this.spoolRules);
        } else if (!this.spoolRules.isEmpty()) {
            LOG.info("StreamCaching in use with rules: {}", this.spoolRules);
        } else {
            LOG.debug("StreamCaching in use");
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.spoolEnabled && this.isSpoolRemovable()) {
            LOG.debug("Removing spool directory: {}", (Object)this.spoolDirectory);
            FileUtil.removeDir(this.spoolDirectory);
        }
        if (LOG.isDebugEnabled() && this.statistics.isStatisticsEnabled()) {
            LOG.debug("Stopping StreamCachingStrategy with statistics: {}", (Object)this.statistics);
        }
        this.statistics.reset();
    }

    private boolean isSpoolRemovable() {
        return this.spoolThreshold > 0L & this.spoolDirectory != null && this.isRemoveSpoolDirectoryWhenStopping();
    }

    public String toString() {
        return "DefaultStreamCachingStrategy[spoolDirectoryEnabled=" + this.spoolEnabled + ", spoolDirectory=" + String.valueOf(this.spoolDirectory) + ", spoolCipher=" + this.spoolCipher + ", spoolThreshold=" + this.spoolThreshold + ", spoolUsedHeapMemoryThreshold=" + this.spoolUsedHeapMemoryThreshold + ", bufferSize=" + this.bufferSize + ", anySpoolRules=" + this.anySpoolRules + "]";
    }

    private static final class UtilizationStatistics
    implements StreamCachingStrategy.Statistics {
        private final Lock lock = new ReentrantLock();
        private boolean statisticsEnabled;
        private final AtomicLong memoryCounter = new AtomicLong();
        private final AtomicLong memorySize = new AtomicLong();
        private final AtomicLong memoryAverageSize = new AtomicLong();
        private final AtomicLong spoolCounter = new AtomicLong();
        private final AtomicLong spoolSize = new AtomicLong();
        private final AtomicLong spoolAverageSize = new AtomicLong();

        private UtilizationStatistics() {
        }

        void updateMemory(long size) {
            this.lock.lock();
            try {
                this.memoryAverageSize.set(this.memorySize.addAndGet(size) / this.memoryCounter.incrementAndGet());
            }
            finally {
                this.lock.unlock();
            }
        }

        void updateSpool(long size) {
            this.lock.lock();
            try {
                this.spoolAverageSize.set(this.spoolSize.addAndGet(size) / this.spoolCounter.incrementAndGet());
            }
            finally {
                this.lock.lock();
            }
        }

        @Override
        public long getCacheMemoryCounter() {
            return this.memoryCounter.get();
        }

        @Override
        public long getCacheMemorySize() {
            return this.memorySize.get();
        }

        @Override
        public long getCacheMemoryAverageSize() {
            return this.memoryAverageSize.get();
        }

        @Override
        public long getCacheSpoolCounter() {
            return this.spoolCounter.get();
        }

        @Override
        public long getCacheSpoolSize() {
            return this.spoolSize.get();
        }

        @Override
        public long getCacheSpoolAverageSize() {
            return this.spoolAverageSize.get();
        }

        @Override
        public void reset() {
            this.lock.lock();
            try {
                this.memoryCounter.set(0L);
                this.memorySize.set(0L);
                this.memoryAverageSize.set(0L);
                this.spoolCounter.set(0L);
                this.spoolSize.set(0L);
                this.spoolAverageSize.set(0L);
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean isStatisticsEnabled() {
            return this.statisticsEnabled;
        }

        @Override
        public void setStatisticsEnabled(boolean statisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
        }

        public String toString() {
            return String.format("[memoryCounter=%s, memorySize=%s, memoryAverageSize=%s, spoolCounter=%s, spoolSize=%s, spoolAverageSize=%s]", this.memoryCounter, this.memorySize, this.memoryAverageSize, this.spoolCounter, this.spoolSize, this.spoolAverageSize);
        }
    }

    private final class FixedThresholdSpoolRule
    implements StreamCachingStrategy.SpoolRule {
        private FixedThresholdSpoolRule() {
        }

        @Override
        public boolean shouldSpoolCache(long length) {
            if (DefaultStreamCachingStrategy.this.spoolThreshold > 0L && length > DefaultStreamCachingStrategy.this.spoolThreshold) {
                LOG.trace("Should spool cache fixed threshold {} > {} -> true", (Object)length, (Object)DefaultStreamCachingStrategy.this.spoolThreshold);
                return true;
            }
            return false;
        }

        public String toString() {
            if (DefaultStreamCachingStrategy.this.spoolThreshold < 1024L) {
                return "Spool > " + DefaultStreamCachingStrategy.this.spoolThreshold + " bytes body size";
            }
            return "Spool > " + (DefaultStreamCachingStrategy.this.spoolThreshold >> 10) + "K body size";
        }
    }

    private final class UsedHeapMemorySpoolRule
    implements StreamCachingStrategy.SpoolRule {
        private final MemoryMXBean heapUsage;
        private final StreamCachingStrategy.SpoolUsedHeapMemoryLimit limit;

        private UsedHeapMemorySpoolRule(StreamCachingStrategy.SpoolUsedHeapMemoryLimit limit) {
            this.limit = limit;
            this.heapUsage = ManagementFactory.getMemoryMXBean();
        }

        @Override
        public boolean shouldSpoolCache(long length) {
            if (DefaultStreamCachingStrategy.this.spoolUsedHeapMemoryThreshold > 0) {
                double used = this.heapUsage.getHeapMemoryUsage().getUsed();
                double upper = this.limit == StreamCachingStrategy.SpoolUsedHeapMemoryLimit.Committed ? (double)this.heapUsage.getHeapMemoryUsage().getCommitted() : (double)this.heapUsage.getHeapMemoryUsage().getMax();
                double calc = used / upper * 100.0;
                int percentage = (int)calc;
                if (LOG.isTraceEnabled()) {
                    long u = this.heapUsage.getHeapMemoryUsage().getUsed();
                    long c = this.heapUsage.getHeapMemoryUsage().getCommitted();
                    long m = this.heapUsage.getHeapMemoryUsage().getMax();
                    LOG.trace("Heap memory: [used={}M ({}%), committed={}M, max={}M]", new Object[]{u >> 20, percentage, c >> 20, m >> 20});
                }
                if (percentage > DefaultStreamCachingStrategy.this.spoolUsedHeapMemoryThreshold) {
                    LOG.trace("Should spool cache heap memory threshold {} > {} -> true", (Object)percentage, (Object)DefaultStreamCachingStrategy.this.spoolUsedHeapMemoryThreshold);
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "Spool > " + DefaultStreamCachingStrategy.this.spoolUsedHeapMemoryThreshold + "% used of " + String.valueOf((Object)this.limit) + " heap memory";
        }
    }
}

