/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.maps.model.LatLng;
import java.io.IOException;

public class LatLngAdapter
extends TypeAdapter<LatLng> {
    @Override
    public LatLng read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        double lat = 0.0;
        double lng = 0.0;
        boolean hasLat = false;
        boolean hasLng = false;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if ("lat".equals(name) || "latitude".equals(name)) {
                lat = reader.nextDouble();
                hasLat = true;
                continue;
            }
            if (!"lng".equals(name) && !"longitude".equals(name)) continue;
            lng = reader.nextDouble();
            hasLng = true;
        }
        reader.endObject();
        if (hasLat && hasLng) {
            return new LatLng(lat, lng);
        }
        return null;
    }

    @Override
    public void write(JsonWriter out, LatLng value) throws IOException {
        throw new UnsupportedOperationException("Unimplemented method.");
    }
}

