/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.geocoder;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.geocoder.GeoCoderEndpoint;
import org.apache.camel.component.geocoder.GeocoderStatus;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.StringHelper;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoCoderNominatimProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(GeoCoderNominatimProducer.class);
    private final GeoCoderEndpoint endpoint;
    private final CloseableHttpClient httpClient = HttpClients.createDefault();

    public GeoCoderNominatimProducer(GeoCoderEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    protected void doStop() throws Exception {
        this.httpClient.close();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String latlng;
        String address = exchange.getIn().getHeader("CamelGeoCoderAddress", String.class);
        if (address == null) {
            address = this.endpoint.getAddress();
        }
        if ((latlng = exchange.getIn().getHeader("CamelGeoCoderLatlng", String.class)) == null) {
            latlng = this.endpoint.getLatlng();
        }
        String geocoded = null;
        if (latlng != null) {
            String lat = StringHelper.before(latlng, ",");
            String lng = StringHelper.after(latlng, ",");
            LOG.debug("Geocode for lat/lng {}", (Object)latlng);
            geocoded = this.query(lat, lng);
        } else if (address != null) {
            LOG.debug("Geocode for address {}", (Object)address);
            geocoded = this.query(address);
        }
        LOG.debug("Geocode response {}", geocoded);
        this.extractResult(geocoded, exchange);
    }

    private String query(String dlat, String dlon) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "jsonv2");
        params.put("lat", dlat);
        params.put("lon", dlon);
        return this.queryForString("reverse", params);
    }

    private String query(String address) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "jsonv2");
        params.put("addressdetails", "1");
        params.put("q", address);
        params.put("limit", "1");
        return this.queryForString("search", params);
    }

    private String queryForString(String operation, Map<String, String> params) throws IOException {
        Object url = this.endpoint.getServerUrl();
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        url = (String)url + operation;
        ClassicRequestBuilder builder = ClassicRequestBuilder.get().setUri((String)url);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.addParameter(entry.getKey(), entry.getValue());
        }
        return this.httpClient.execute(builder.build(), resp -> EntityUtils.toString(resp.getEntity()));
    }

    protected void extractResult(String place, Exchange exchange) {
        if (!this.endpoint.isHeadersOnly()) {
            exchange.getIn().setBody(place);
        }
        if (place == null || place.isEmpty()) {
            exchange.getIn().setHeader("CamelGeoCoderStatus", (Object)GeocoderStatus.ZERO_RESULTS);
            return;
        }
        exchange.getIn().setHeader("CamelGeoCoderStatus", (Object)GeocoderStatus.OK);
        if (place.startsWith("[") && place.endsWith("]")) {
            place = place.substring(1, place.length() - 1);
        }
        Configuration conf = Configuration.defaultConfiguration().addOptions(Option.SUPPRESS_EXCEPTIONS);
        DocumentContext doc = JsonPath.using(conf).parse(place);
        exchange.getIn().setHeader("CamelGeoCoderAddress", doc.read("$['display_name']", new Predicate[0]));
        this.setLatLngToExchangeHeader((String)doc.read("$['lat']", new Predicate[0]), (String)doc.read("$['lon']", new Predicate[0]), exchange);
        this.extractCountry(doc, exchange.getIn());
        this.extractCity(doc, exchange.getIn());
        this.extractPostalCode(doc, exchange.getIn());
        this.extractRegion(doc, exchange.getIn());
    }

    private void setLatLngToExchangeHeader(String resLat, String resLng, Exchange exchange) {
        if (resLat != null && resLng != null) {
            exchange.getIn().setHeader("CamelGeoCoderLat", this.formatLatOrLon(resLat));
            exchange.getIn().setHeader("CamelGeoCoderLng", this.formatLatOrLon(resLng));
            String resLatlng = this.formatLatOrLon(resLat) + ", " + this.formatLatOrLon(resLng);
            exchange.getIn().setHeader("CamelGeoCoderLatlng", resLatlng);
        }
    }

    private void extractCountry(DocumentContext doc, Message in) {
        String code = (String)doc.read("$['address']['country_code']", new Predicate[0]);
        if (code != null) {
            code = code.toUpperCase();
        }
        in.setHeader("CamelGeoCoderCountryShort", code);
        in.setHeader("CamelGeoCoderCountryLong", doc.read("$['address']['country']", new Predicate[0]));
    }

    private void extractCity(DocumentContext doc, Message in) {
        in.setHeader("CamelGeoCoderCity", doc.read("$['address']['city']", new Predicate[0]));
    }

    private void extractPostalCode(DocumentContext doc, Message in) {
        in.setHeader("CamelGeoCoderPostalCode", doc.read("$['address']['postcode']", new Predicate[0]));
    }

    private void extractRegion(DocumentContext doc, Message in) {
        String code = (String)doc.read("$['address']['state_code']", new Predicate[0]);
        if (code != null) {
            code = code.toUpperCase();
        }
        in.setHeader("CamelGeoCoderRegionCode", code);
        in.setHeader("CamelGeoCoderRegionName", doc.read("$['address']['state']", new Predicate[0]));
    }

    private String formatLatOrLon(String value) {
        return String.format(Locale.ENGLISH, "%.8f", Double.parseDouble(value));
    }
}

