/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps;

import com.google.gson.FieldNamingPolicy;
import com.google.maps.GeoApiContext;
import com.google.maps.PendingResultBase;
import com.google.maps.RoadsApi;
import com.google.maps.internal.ApiConfig;
import com.google.maps.internal.StringJoin;
import com.google.maps.model.LatLng;
import com.google.maps.model.SnappedPoint;

public class NearestRoadsApiRequest
extends PendingResultBase<SnappedPoint[], NearestRoadsApiRequest, RoadsApi.RoadsResponse> {
    private static final ApiConfig NEAREST_ROADS_API_CONFIG = new ApiConfig("/v1/nearestRoads").hostName("https://roads.googleapis.com").supportsClientId(false).fieldNamingPolicy(FieldNamingPolicy.IDENTITY);

    public NearestRoadsApiRequest(GeoApiContext context) {
        super(context, NEAREST_ROADS_API_CONFIG, RoadsApi.RoadsResponse.class);
    }

    @Override
    protected void validateRequest() {
        if (!this.params().containsKey("points")) {
            throw new IllegalArgumentException("Request must contain 'path");
        }
    }

    public NearestRoadsApiRequest points(LatLng ... points) {
        return (NearestRoadsApiRequest)this.param("points", StringJoin.join('|', points));
    }
}

