/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.Instant;

public class InstantAdapter
extends TypeAdapter<Instant> {
    @Override
    public Instant read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        if (reader.peek() == JsonToken.NUMBER) {
            return Instant.ofEpochMilli(reader.nextLong() * 1000L);
        }
        throw new UnsupportedOperationException("Unsupported format");
    }

    @Override
    public void write(JsonWriter out, Instant value) throws IOException {
        throw new UnsupportedOperationException("Unimplemented method");
    }
}

