/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.internal;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class LocalTimeAdapter
extends TypeAdapter<LocalTime> {
    @Override
    public LocalTime read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        if (reader.peek() == JsonToken.STRING) {
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("HHmm");
            return LocalTime.parse(reader.nextString(), dtf);
        }
        throw new UnsupportedOperationException("Unsupported format");
    }

    @Override
    public void write(JsonWriter out, LocalTime value) throws IOException {
        throw new UnsupportedOperationException("Unimplemented method");
    }
}

