/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.consumer;

import java.util.ArrayDeque;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.consumer.AbstractGitHubConsumer;
import org.apache.camel.spi.Registry;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestConsumer
extends AbstractGitHubConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(PullRequestConsumer.class);
    private PullRequestService pullRequestService;
    private int lastOpenPullRequest;

    public PullRequestConsumer(GitHubEndpoint endpoint, Processor processor) throws Exception {
        super(endpoint, processor);
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubPullRequestService");
        if (service != null) {
            LOG.debug("Using PullRequestService found in registry {}", (Object)service.getClass().getCanonicalName());
            this.pullRequestService = (PullRequestService)service;
        } else {
            this.pullRequestService = new PullRequestService();
        }
        this.initService(this.pullRequestService);
        LOG.info("GitHub PullRequestConsumer: Indexing current pull requests...");
        List<PullRequest> pullRequests = this.pullRequestService.getPullRequests(this.getRepository(), "open");
        if (!pullRequests.isEmpty()) {
            this.lastOpenPullRequest = pullRequests.get(0).getNumber();
        }
    }

    @Override
    protected int poll() throws Exception {
        List<PullRequest> openPullRequests = this.pullRequestService.getPullRequests(this.getRepository(), "open");
        ArrayDeque<PullRequest> newPullRequests = new ArrayDeque<PullRequest>();
        for (PullRequest pullRequest : openPullRequests) {
            if (pullRequest.getNumber() <= this.lastOpenPullRequest) break;
            newPullRequests.push(pullRequest);
        }
        if (!newPullRequests.isEmpty()) {
            this.lastOpenPullRequest = openPullRequests.get(0).getNumber();
        }
        int counter = 0;
        while (!newPullRequests.isEmpty()) {
            PullRequest newPullRequest = (PullRequest)newPullRequests.pop();
            Exchange e = this.createExchange(true);
            e.getIn().setBody(newPullRequest);
            e.getIn().setHeader("GitHubPullRequest", newPullRequest.getNumber());
            if (newPullRequest.getHead() != null) {
                e.getIn().setHeader("GitHubPullRequestHeadCommitSHA", newPullRequest.getHead().getSha());
            }
            this.getProcessor().process(e);
            ++counter;
        }
        return counter;
    }
}

