/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.producer.AbstractGitHubProducer;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.service.IssueService;

public class CreateIssueProducer
extends AbstractGitHubProducer {
    private IssueService issueService;

    public CreateIssueProducer(GitHubEndpoint endpoint) throws Exception {
        super(endpoint);
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githbIssueService");
        this.issueService = service != null ? (IssueService)service : new IssueService();
        this.initService(this.issueService);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Issue issue = new Issue();
        String issueTitle = exchange.getIn().getHeader("GitHubIssueTitle", String.class);
        if (ObjectHelper.isEmpty(issueTitle)) {
            throw new IllegalArgumentException("Issue Title must be specified to create an issue");
        }
        issue.setTitle(issueTitle);
        issue.setBody(exchange.getIn().getBody(String.class));
        Issue finalIssue = this.issueService.createIssue(this.getRepository(), issue);
        exchange.getOut().copyFrom(exchange.getIn());
        exchange.getOut().setBody(finalIssue);
    }
}

