/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.producer.AbstractGitHubProducer;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.ExchangeHelper;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestCommentProducer
extends AbstractGitHubProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(PullRequestCommentProducer.class);
    private PullRequestService pullRequestService;
    private IssueService issueService;

    public PullRequestCommentProducer(GitHubEndpoint endpoint) throws Exception {
        super(endpoint);
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubPullRequestService");
        if (service != null) {
            LOG.debug("Using PullRequestService found in registry {}", (Object)service.getClass().getCanonicalName());
            this.pullRequestService = (PullRequestService)service;
        } else {
            this.pullRequestService = new PullRequestService();
        }
        this.initService(this.pullRequestService);
        service = registry.lookupByName("githbIssueService");
        this.issueService = service != null ? (IssueService)service : new IssueService();
        this.initService(this.issueService);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Integer pullRequestNumber = exchange.getIn().getHeader("GitHubPullRequest", Integer.class);
        Integer inResponseTo = exchange.getIn().getHeader("GitHubInResponseTo", Integer.class);
        String text = exchange.getIn().getBody(String.class);
        Comment response = inResponseTo != null && inResponseTo > 0 ? this.pullRequestService.replyToComment(this.getRepository(), pullRequestNumber, inResponseTo, text) : this.issueService.createComment((IRepositoryIdProvider)this.getRepository(), pullRequestNumber, text);
        ExchangeHelper.setOutBodyPatternAware(exchange, response);
    }
}

