/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CloudFunctionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FUNCTION = PathTemplate.createWithoutUrlEncoding("projects/{project}/locations/{location}/functions/{function}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String function;

    @Deprecated
    protected CloudFunctionName() {
        this.project = null;
        this.location = null;
        this.function = null;
    }

    private CloudFunctionName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.location = Preconditions.checkNotNull(builder.getLocation());
        this.function = Preconditions.checkNotNull(builder.getFunction());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFunction() {
        return this.function;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CloudFunctionName of(String project, String location, String function) {
        return CloudFunctionName.newBuilder().setProject(project).setLocation(location).setFunction(function).build();
    }

    public static String format(String project, String location, String function) {
        return CloudFunctionName.newBuilder().setProject(project).setLocation(location).setFunction(function).build().toString();
    }

    public static CloudFunctionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_LOCATION_FUNCTION.validatedMatch(formattedString, "CloudFunctionName.parse: formattedString not in valid format");
        return CloudFunctionName.of(matchMap.get("project"), matchMap.get("location"), matchMap.get("function"));
    }

    public static List<CloudFunctionName> parseList(List<String> formattedStrings) {
        ArrayList<CloudFunctionName> list = new ArrayList<CloudFunctionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CloudFunctionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CloudFunctionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CloudFunctionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FUNCTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CloudFunctionName cloudFunctionName = this;
            synchronized (cloudFunctionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put("location", this.location);
                    }
                    if (this.function != null) {
                        fieldMapBuilder.put("function", this.function);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_FUNCTION.instantiate("project", this.project, "location", this.location, "function", this.function);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CloudFunctionName that = (CloudFunctionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.function, that.function);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.location);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.function);
    }

    public static class Builder {
        private String project;
        private String location;
        private String function;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFunction() {
            return this.function;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFunction(String function) {
            this.function = function;
            return this;
        }

        private Builder(CloudFunctionName cloudFunctionName) {
            this.project = cloudFunctionName.project;
            this.location = cloudFunctionName.location;
            this.function = cloudFunctionName.function;
        }

        public CloudFunctionName build() {
            return new CloudFunctionName(this);
        }
    }
}

