/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.v2alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.functions.v2alpha.CreateFunctionRequest;
import com.google.cloud.functions.v2alpha.DeleteFunctionRequest;
import com.google.cloud.functions.v2alpha.Function;
import com.google.cloud.functions.v2alpha.FunctionServiceClient;
import com.google.cloud.functions.v2alpha.GenerateDownloadUrlRequest;
import com.google.cloud.functions.v2alpha.GenerateDownloadUrlResponse;
import com.google.cloud.functions.v2alpha.GenerateUploadUrlRequest;
import com.google.cloud.functions.v2alpha.GenerateUploadUrlResponse;
import com.google.cloud.functions.v2alpha.GetFunctionRequest;
import com.google.cloud.functions.v2alpha.ListFunctionsRequest;
import com.google.cloud.functions.v2alpha.ListFunctionsResponse;
import com.google.cloud.functions.v2alpha.ListRuntimesRequest;
import com.google.cloud.functions.v2alpha.ListRuntimesResponse;
import com.google.cloud.functions.v2alpha.OperationMetadata;
import com.google.cloud.functions.v2alpha.UpdateFunctionRequest;
import com.google.cloud.functions.v2alpha.stub.FunctionServiceStub;
import com.google.cloud.functions.v2alpha.stub.FunctionServiceStubSettings;
import com.google.cloud.functions.v2alpha.stub.GrpcFunctionServiceCallableFactory;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcFunctionServiceStub
extends FunctionServiceStub {
    private static final MethodDescriptor<GetFunctionRequest, Function> getFunctionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2alpha.FunctionService/GetFunction").setRequestMarshaller(ProtoUtils.marshaller(GetFunctionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Function.getDefaultInstance())).build();
    private static final MethodDescriptor<ListFunctionsRequest, ListFunctionsResponse> listFunctionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2alpha.FunctionService/ListFunctions").setRequestMarshaller(ProtoUtils.marshaller(ListFunctionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ListFunctionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateFunctionRequest, Operation> createFunctionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2alpha.FunctionService/CreateFunction").setRequestMarshaller(ProtoUtils.marshaller(CreateFunctionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateFunctionRequest, Operation> updateFunctionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2alpha.FunctionService/UpdateFunction").setRequestMarshaller(ProtoUtils.marshaller(UpdateFunctionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteFunctionRequest, Operation> deleteFunctionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2alpha.FunctionService/DeleteFunction").setRequestMarshaller(ProtoUtils.marshaller(DeleteFunctionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2alpha.FunctionService/GenerateUploadUrl").setRequestMarshaller(ProtoUtils.marshaller(GenerateUploadUrlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(GenerateUploadUrlResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2alpha.FunctionService/GenerateDownloadUrl").setRequestMarshaller(ProtoUtils.marshaller(GenerateDownloadUrlRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(GenerateDownloadUrlResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListRuntimesRequest, ListRuntimesResponse> listRuntimesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.functions.v2alpha.FunctionService/ListRuntimes").setRequestMarshaller(ProtoUtils.marshaller(ListRuntimesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ListRuntimesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller(ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller(SetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setRequestMarshaller(ProtoUtils.marshaller(GetIamPolicyRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(Policy.getDefaultInstance())).build();
    private static final MethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setRequestMarshaller(ProtoUtils.marshaller(TestIamPermissionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(TestIamPermissionsResponse.getDefaultInstance())).build();
    private final UnaryCallable<GetFunctionRequest, Function> getFunctionCallable;
    private final UnaryCallable<ListFunctionsRequest, ListFunctionsResponse> listFunctionsCallable;
    private final UnaryCallable<ListFunctionsRequest, FunctionServiceClient.ListFunctionsPagedResponse> listFunctionsPagedCallable;
    private final UnaryCallable<CreateFunctionRequest, Operation> createFunctionCallable;
    private final OperationCallable<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationCallable;
    private final UnaryCallable<UpdateFunctionRequest, Operation> updateFunctionCallable;
    private final OperationCallable<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationCallable;
    private final UnaryCallable<DeleteFunctionRequest, Operation> deleteFunctionCallable;
    private final OperationCallable<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationCallable;
    private final UnaryCallable<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlCallable;
    private final UnaryCallable<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlCallable;
    private final UnaryCallable<ListRuntimesRequest, ListRuntimesResponse> listRuntimesCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, FunctionServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcFunctionServiceStub create(FunctionServiceStubSettings settings) throws IOException {
        return new GrpcFunctionServiceStub(settings, ClientContext.create(settings));
    }

    public static final GrpcFunctionServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcFunctionServiceStub(FunctionServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcFunctionServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcFunctionServiceStub(FunctionServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcFunctionServiceStub(FunctionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcFunctionServiceCallableFactory());
    }

    protected GrpcFunctionServiceStub(FunctionServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create(clientContext, callableFactory);
        GrpcCallSettings<GetFunctionRequest, Function> getFunctionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getFunctionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<ListFunctionsRequest, ListFunctionsResponse> listFunctionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listFunctionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings<CreateFunctionRequest, Operation> createFunctionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createFunctionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings<UpdateFunctionRequest, Operation> updateFunctionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateFunctionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("function.name", String.valueOf(request.getFunction().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<DeleteFunctionRequest, Operation> deleteFunctionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteFunctionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateUploadUrlMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateDownloadUrlMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<ListRuntimesRequest, ListRuntimesResponse> listRuntimesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRuntimesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings<ListLocationsRequest, ListLocationsResponse> listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings<SetIamPolicyRequest, Policy> setIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings<GetIamPolicyRequest, Policy> getIamPolicyTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        GrpcCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.getFunctionCallable = callableFactory.createUnaryCallable(getFunctionTransportSettings, settings.getFunctionSettings(), clientContext);
        this.listFunctionsCallable = callableFactory.createUnaryCallable(listFunctionsTransportSettings, settings.listFunctionsSettings(), clientContext);
        this.listFunctionsPagedCallable = callableFactory.createPagedCallable(listFunctionsTransportSettings, settings.listFunctionsSettings(), clientContext);
        this.createFunctionCallable = callableFactory.createUnaryCallable(createFunctionTransportSettings, settings.createFunctionSettings(), clientContext);
        this.createFunctionOperationCallable = callableFactory.createOperationCallable(createFunctionTransportSettings, settings.createFunctionOperationSettings(), clientContext, this.operationsStub);
        this.updateFunctionCallable = callableFactory.createUnaryCallable(updateFunctionTransportSettings, settings.updateFunctionSettings(), clientContext);
        this.updateFunctionOperationCallable = callableFactory.createOperationCallable(updateFunctionTransportSettings, settings.updateFunctionOperationSettings(), clientContext, this.operationsStub);
        this.deleteFunctionCallable = callableFactory.createUnaryCallable(deleteFunctionTransportSettings, settings.deleteFunctionSettings(), clientContext);
        this.deleteFunctionOperationCallable = callableFactory.createOperationCallable(deleteFunctionTransportSettings, settings.deleteFunctionOperationSettings(), clientContext, this.operationsStub);
        this.generateUploadUrlCallable = callableFactory.createUnaryCallable(generateUploadUrlTransportSettings, settings.generateUploadUrlSettings(), clientContext);
        this.generateDownloadUrlCallable = callableFactory.createUnaryCallable(generateDownloadUrlTransportSettings, settings.generateDownloadUrlSettings(), clientContext);
        this.listRuntimesCallable = callableFactory.createUnaryCallable(listRuntimesTransportSettings, settings.listRuntimesSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetFunctionRequest, Function> getFunctionCallable() {
        return this.getFunctionCallable;
    }

    @Override
    public UnaryCallable<ListFunctionsRequest, ListFunctionsResponse> listFunctionsCallable() {
        return this.listFunctionsCallable;
    }

    @Override
    public UnaryCallable<ListFunctionsRequest, FunctionServiceClient.ListFunctionsPagedResponse> listFunctionsPagedCallable() {
        return this.listFunctionsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateFunctionRequest, Operation> createFunctionCallable() {
        return this.createFunctionCallable;
    }

    @Override
    public OperationCallable<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationCallable() {
        return this.createFunctionOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateFunctionRequest, Operation> updateFunctionCallable() {
        return this.updateFunctionCallable;
    }

    @Override
    public OperationCallable<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationCallable() {
        return this.updateFunctionOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteFunctionRequest, Operation> deleteFunctionCallable() {
        return this.deleteFunctionCallable;
    }

    @Override
    public OperationCallable<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationCallable() {
        return this.deleteFunctionOperationCallable;
    }

    @Override
    public UnaryCallable<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlCallable() {
        return this.generateUploadUrlCallable;
    }

    @Override
    public UnaryCallable<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlCallable() {
        return this.generateDownloadUrlCallable;
    }

    @Override
    public UnaryCallable<ListRuntimesRequest, ListRuntimesResponse> listRuntimesCallable() {
        return this.listRuntimesCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, FunctionServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    @Override
    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

