/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import com.google.common.annotations.VisibleForTesting;
import com.google.errorprone.annotations.InlineMe;
import io.grpc.Context;
import io.grpc.ExperimentalApi;
import io.grpc.services.MetricRecorderHelper;
import io.grpc.services.MetricReport;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/6012")
@ThreadSafe
public final class CallMetricRecorder {
    private static final CallMetricRecorder NOOP = new CallMetricRecorder().disable();
    static final Context.Key<CallMetricRecorder> CONTEXT_KEY = Context.key("io.grpc.services.CallMetricRecorder");
    private final AtomicReference<ConcurrentHashMap<String, Double>> utilizationMetrics = new AtomicReference();
    private final AtomicReference<ConcurrentHashMap<String, Double>> requestCostMetrics = new AtomicReference();
    private final AtomicReference<ConcurrentHashMap<String, Double>> namedMetrics = new AtomicReference();
    private double cpuUtilizationMetric = 0.0;
    private double applicationUtilizationMetric = 0.0;
    private double memoryUtilizationMetric = 0.0;
    private double qps = 0.0;
    private double eps = 0.0;
    private volatile boolean disabled;

    public static CallMetricRecorder getCurrent() {
        CallMetricRecorder recorder = CONTEXT_KEY.get();
        return recorder != null ? recorder : NOOP;
    }

    public CallMetricRecorder recordUtilizationMetric(String name, double value) {
        if (this.disabled || !MetricRecorderHelper.isUtilizationValid(value)) {
            return this;
        }
        if (this.utilizationMetrics.get() == null) {
            this.utilizationMetrics.compareAndSet(null, new ConcurrentHashMap());
        }
        this.utilizationMetrics.get().put(name, value);
        return this;
    }

    @Deprecated
    @InlineMe(replacement="this.recordRequestCostMetric(name, value)")
    public CallMetricRecorder recordCallMetric(String name, double value) {
        return this.recordRequestCostMetric(name, value);
    }

    public CallMetricRecorder recordRequestCostMetric(String name, double value) {
        if (this.disabled) {
            return this;
        }
        if (this.requestCostMetrics.get() == null) {
            this.requestCostMetrics.compareAndSet(null, new ConcurrentHashMap());
        }
        this.requestCostMetrics.get().put(name, value);
        return this;
    }

    public CallMetricRecorder recordNamedMetric(String name, double value) {
        if (this.disabled) {
            return this;
        }
        if (this.namedMetrics.get() == null) {
            this.namedMetrics.compareAndSet(null, new ConcurrentHashMap());
        }
        this.namedMetrics.get().put(name, value);
        return this;
    }

    public CallMetricRecorder recordCpuUtilizationMetric(double value) {
        if (this.disabled || !MetricRecorderHelper.isCpuOrApplicationUtilizationValid(value)) {
            return this;
        }
        this.cpuUtilizationMetric = value;
        return this;
    }

    public CallMetricRecorder recordApplicationUtilizationMetric(double value) {
        if (this.disabled || !MetricRecorderHelper.isCpuOrApplicationUtilizationValid(value)) {
            return this;
        }
        this.applicationUtilizationMetric = value;
        return this;
    }

    public CallMetricRecorder recordMemoryUtilizationMetric(double value) {
        if (this.disabled || !MetricRecorderHelper.isUtilizationValid(value)) {
            return this;
        }
        this.memoryUtilizationMetric = value;
        return this;
    }

    public CallMetricRecorder recordQpsMetric(double value) {
        if (this.disabled || !MetricRecorderHelper.isRateValid(value)) {
            return this;
        }
        this.qps = value;
        return this;
    }

    public CallMetricRecorder recordEpsMetric(double value) {
        if (this.disabled || !MetricRecorderHelper.isRateValid(value)) {
            return this;
        }
        this.eps = value;
        return this;
    }

    Map<String, Double> finalizeAndDump() {
        this.disabled = true;
        Map savedMetrics = this.requestCostMetrics.get();
        if (savedMetrics == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(savedMetrics);
    }

    MetricReport finalizeAndDump2() {
        Map<String, Double> savedRequestCostMetrics = this.finalizeAndDump();
        Map savedUtilizationMetrics = this.utilizationMetrics.get();
        Map savedNamedMetrics = this.namedMetrics.get();
        if (savedUtilizationMetrics == null) {
            savedUtilizationMetrics = Collections.emptyMap();
        }
        if (savedNamedMetrics == null) {
            savedNamedMetrics = Collections.emptyMap();
        }
        return new MetricReport(this.cpuUtilizationMetric, this.applicationUtilizationMetric, this.memoryUtilizationMetric, this.qps, this.eps, Collections.unmodifiableMap(savedRequestCostMetrics), Collections.unmodifiableMap(savedUtilizationMetrics), Collections.unmodifiableMap(savedNamedMetrics));
    }

    @VisibleForTesting
    boolean isDisabled() {
        return this.disabled;
    }

    private CallMetricRecorder disable() {
        this.disabled = true;
        return this;
    }
}

