/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.functions;

import com.google.cloud.functions.v1.CloudFunctionsServiceClient;
import org.apache.camel.CamelContext;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsEndpoint;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsOperations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;

public class GoogleCloudFunctionsEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        GoogleCloudFunctionsEndpoint target = (GoogleCloudFunctionsEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "client": {
                target.getConfiguration().setClient(GoogleCloudFunctionsEndpointConfigurer.property(camelContext, CloudFunctionsServiceClient.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(GoogleCloudFunctionsEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "location": {
                target.getConfiguration().setLocation(GoogleCloudFunctionsEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "operation": {
                target.getConfiguration().setOperation(GoogleCloudFunctionsEndpointConfigurer.property(camelContext, GoogleCloudFunctionsOperations.class, value));
                return true;
            }
            case "pojorequest": 
            case "pojoRequest": {
                target.getConfiguration().setPojoRequest(GoogleCloudFunctionsEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "project": {
                target.getConfiguration().setProject(GoogleCloudFunctionsEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "serviceaccountkey": 
            case "serviceAccountKey": {
                target.getConfiguration().setServiceAccountKey(GoogleCloudFunctionsEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] getAutowiredNames() {
        return new String[]{"client"};
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "client": {
                return CloudFunctionsServiceClient.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "location": {
                return String.class;
            }
            case "operation": {
                return GoogleCloudFunctionsOperations.class;
            }
            case "pojorequest": 
            case "pojoRequest": {
                return Boolean.TYPE;
            }
            case "project": {
                return String.class;
            }
            case "serviceaccountkey": 
            case "serviceAccountKey": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        GoogleCloudFunctionsEndpoint target = (GoogleCloudFunctionsEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "client": {
                return target.getConfiguration().getClient();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "location": {
                return target.getConfiguration().getLocation();
            }
            case "operation": {
                return target.getConfiguration().getOperation();
            }
            case "pojorequest": 
            case "pojoRequest": {
                return target.getConfiguration().isPojoRequest();
            }
            case "project": {
                return target.getConfiguration().getProject();
            }
            case "serviceaccountkey": 
            case "serviceAccountKey": {
                return target.getConfiguration().getServiceAccountKey();
            }
        }
        return null;
    }
}

