/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.functions.v1.CallFunctionRequest;
import com.google.cloud.functions.v1.CallFunctionResponse;
import com.google.cloud.functions.v1.CloudFunction;
import com.google.cloud.functions.v1.CloudFunctionName;
import com.google.cloud.functions.v1.CloudFunctionsServiceSettings;
import com.google.cloud.functions.v1.CreateFunctionRequest;
import com.google.cloud.functions.v1.DeleteFunctionRequest;
import com.google.cloud.functions.v1.GenerateDownloadUrlRequest;
import com.google.cloud.functions.v1.GenerateDownloadUrlResponse;
import com.google.cloud.functions.v1.GenerateUploadUrlRequest;
import com.google.cloud.functions.v1.GenerateUploadUrlResponse;
import com.google.cloud.functions.v1.GetFunctionRequest;
import com.google.cloud.functions.v1.ListFunctionsRequest;
import com.google.cloud.functions.v1.ListFunctionsResponse;
import com.google.cloud.functions.v1.LocationName;
import com.google.cloud.functions.v1.OperationMetadataV1;
import com.google.cloud.functions.v1.UpdateFunctionRequest;
import com.google.cloud.functions.v1.stub.CloudFunctionsServiceStub;
import com.google.cloud.functions.v1.stub.CloudFunctionsServiceStubSettings;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CloudFunctionsServiceClient
implements BackgroundResource {
    private final CloudFunctionsServiceSettings settings;
    private final CloudFunctionsServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final CloudFunctionsServiceClient create() throws IOException {
        return CloudFunctionsServiceClient.create(CloudFunctionsServiceSettings.newBuilder().build());
    }

    public static final CloudFunctionsServiceClient create(CloudFunctionsServiceSettings settings) throws IOException {
        return new CloudFunctionsServiceClient(settings);
    }

    public static final CloudFunctionsServiceClient create(CloudFunctionsServiceStub stub) {
        return new CloudFunctionsServiceClient(stub);
    }

    protected CloudFunctionsServiceClient(CloudFunctionsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudFunctionsServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create(this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create(this.stub.getHttpJsonOperationsStub());
    }

    protected CloudFunctionsServiceClient(CloudFunctionsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create(this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create(this.stub.getHttpJsonOperationsStub());
    }

    public final CloudFunctionsServiceSettings getSettings() {
        return this.settings;
    }

    public CloudFunctionsServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListFunctionsPagedResponse listFunctions(ListFunctionsRequest request) {
        return this.listFunctionsPagedCallable().call(request);
    }

    public final UnaryCallable<ListFunctionsRequest, ListFunctionsPagedResponse> listFunctionsPagedCallable() {
        return this.stub.listFunctionsPagedCallable();
    }

    public final UnaryCallable<ListFunctionsRequest, ListFunctionsResponse> listFunctionsCallable() {
        return this.stub.listFunctionsCallable();
    }

    public final CloudFunction getFunction(CloudFunctionName name) {
        GetFunctionRequest request = GetFunctionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFunction(request);
    }

    public final CloudFunction getFunction(String name) {
        GetFunctionRequest request = GetFunctionRequest.newBuilder().setName(name).build();
        return this.getFunction(request);
    }

    public final CloudFunction getFunction(GetFunctionRequest request) {
        return this.getFunctionCallable().call(request);
    }

    public final UnaryCallable<GetFunctionRequest, CloudFunction> getFunctionCallable() {
        return this.stub.getFunctionCallable();
    }

    public final OperationFuture<CloudFunction, OperationMetadataV1> createFunctionAsync(LocationName location, CloudFunction function) {
        CreateFunctionRequest request = CreateFunctionRequest.newBuilder().setLocation(location == null ? null : location.toString()).setFunction(function).build();
        return this.createFunctionAsync(request);
    }

    public final OperationFuture<CloudFunction, OperationMetadataV1> createFunctionAsync(String location, CloudFunction function) {
        CreateFunctionRequest request = CreateFunctionRequest.newBuilder().setLocation(location).setFunction(function).build();
        return this.createFunctionAsync(request);
    }

    public final OperationFuture<CloudFunction, OperationMetadataV1> createFunctionAsync(CreateFunctionRequest request) {
        return this.createFunctionOperationCallable().futureCall(request);
    }

    public final OperationCallable<CreateFunctionRequest, CloudFunction, OperationMetadataV1> createFunctionOperationCallable() {
        return this.stub.createFunctionOperationCallable();
    }

    public final UnaryCallable<CreateFunctionRequest, Operation> createFunctionCallable() {
        return this.stub.createFunctionCallable();
    }

    public final OperationFuture<CloudFunction, OperationMetadataV1> updateFunctionAsync(CloudFunction function) {
        UpdateFunctionRequest request = UpdateFunctionRequest.newBuilder().setFunction(function).build();
        return this.updateFunctionAsync(request);
    }

    public final OperationFuture<CloudFunction, OperationMetadataV1> updateFunctionAsync(UpdateFunctionRequest request) {
        return this.updateFunctionOperationCallable().futureCall(request);
    }

    public final OperationCallable<UpdateFunctionRequest, CloudFunction, OperationMetadataV1> updateFunctionOperationCallable() {
        return this.stub.updateFunctionOperationCallable();
    }

    public final UnaryCallable<UpdateFunctionRequest, Operation> updateFunctionCallable() {
        return this.stub.updateFunctionCallable();
    }

    public final OperationFuture<Empty, OperationMetadataV1> deleteFunctionAsync(CloudFunctionName name) {
        DeleteFunctionRequest request = DeleteFunctionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteFunctionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadataV1> deleteFunctionAsync(String name) {
        DeleteFunctionRequest request = DeleteFunctionRequest.newBuilder().setName(name).build();
        return this.deleteFunctionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadataV1> deleteFunctionAsync(DeleteFunctionRequest request) {
        return this.deleteFunctionOperationCallable().futureCall(request);
    }

    public final OperationCallable<DeleteFunctionRequest, Empty, OperationMetadataV1> deleteFunctionOperationCallable() {
        return this.stub.deleteFunctionOperationCallable();
    }

    public final UnaryCallable<DeleteFunctionRequest, Operation> deleteFunctionCallable() {
        return this.stub.deleteFunctionCallable();
    }

    public final CallFunctionResponse callFunction(CloudFunctionName name, String data) {
        CallFunctionRequest request = CallFunctionRequest.newBuilder().setName(name == null ? null : name.toString()).setData(data).build();
        return this.callFunction(request);
    }

    public final CallFunctionResponse callFunction(String name, String data) {
        CallFunctionRequest request = CallFunctionRequest.newBuilder().setName(name).setData(data).build();
        return this.callFunction(request);
    }

    public final CallFunctionResponse callFunction(CallFunctionRequest request) {
        return this.callFunctionCallable().call(request);
    }

    public final UnaryCallable<CallFunctionRequest, CallFunctionResponse> callFunctionCallable() {
        return this.stub.callFunctionCallable();
    }

    public final GenerateUploadUrlResponse generateUploadUrl(GenerateUploadUrlRequest request) {
        return this.generateUploadUrlCallable().call(request);
    }

    public final UnaryCallable<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlCallable() {
        return this.stub.generateUploadUrlCallable();
    }

    public final GenerateDownloadUrlResponse generateDownloadUrl(GenerateDownloadUrlRequest request) {
        return this.generateDownloadUrlCallable().call(request);
    }

    public final UnaryCallable<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlCallable() {
        return this.stub.generateDownloadUrlCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return this.setIamPolicyCallable().call(request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return this.getIamPolicyCallable().call(request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return this.testIamPermissionsCallable().call(request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return this.listLocationsPagedCallable().call(request);
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    @Override
    public final void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        @Override
        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        @Override
        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        @Override
        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)input), MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super(page, ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFunctionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFunctionsRequest, ListFunctionsResponse, CloudFunction, ListFunctionsPage, ListFunctionsFixedSizeCollection> {
        private ListFunctionsFixedSizeCollection(List<ListFunctionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFunctionsFixedSizeCollection createEmptyCollection() {
            return new ListFunctionsFixedSizeCollection(null, 0);
        }

        @Override
        protected ListFunctionsFixedSizeCollection createCollection(List<ListFunctionsPage> pages, int collectionSize) {
            return new ListFunctionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFunctionsPage
    extends AbstractPage<ListFunctionsRequest, ListFunctionsResponse, CloudFunction, ListFunctionsPage> {
        private ListFunctionsPage(PageContext<ListFunctionsRequest, ListFunctionsResponse, CloudFunction> context, ListFunctionsResponse response) {
            super(context, response);
        }

        private static ListFunctionsPage createEmptyPage() {
            return new ListFunctionsPage(null, null);
        }

        @Override
        protected ListFunctionsPage createPage(PageContext<ListFunctionsRequest, ListFunctionsResponse, CloudFunction> context, ListFunctionsResponse response) {
            return new ListFunctionsPage(context, response);
        }

        @Override
        public ApiFuture<ListFunctionsPage> createPageAsync(PageContext<ListFunctionsRequest, ListFunctionsResponse, CloudFunction> context, ApiFuture<ListFunctionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFunctionsPagedResponse
    extends AbstractPagedListResponse<ListFunctionsRequest, ListFunctionsResponse, CloudFunction, ListFunctionsPage, ListFunctionsFixedSizeCollection> {
        public static ApiFuture<ListFunctionsPagedResponse> createAsync(PageContext<ListFunctionsRequest, ListFunctionsResponse, CloudFunction> context, ApiFuture<ListFunctionsResponse> futureResponse) {
            ApiFuture<ListFunctionsPage> futurePage = ListFunctionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFunctionsPagedResponse((ListFunctionsPage)input), MoreExecutors.directExecutor());
        }

        private ListFunctionsPagedResponse(ListFunctionsPage page) {
            super(page, ListFunctionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

