/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.v2;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.functions.v2.CreateFunctionRequest;
import com.google.cloud.functions.v2.DeleteFunctionRequest;
import com.google.cloud.functions.v2.Function;
import com.google.cloud.functions.v2.FunctionName;
import com.google.cloud.functions.v2.FunctionServiceSettings;
import com.google.cloud.functions.v2.GenerateDownloadUrlRequest;
import com.google.cloud.functions.v2.GenerateDownloadUrlResponse;
import com.google.cloud.functions.v2.GenerateUploadUrlRequest;
import com.google.cloud.functions.v2.GenerateUploadUrlResponse;
import com.google.cloud.functions.v2.GetFunctionRequest;
import com.google.cloud.functions.v2.ListFunctionsRequest;
import com.google.cloud.functions.v2.ListFunctionsResponse;
import com.google.cloud.functions.v2.ListRuntimesRequest;
import com.google.cloud.functions.v2.ListRuntimesResponse;
import com.google.cloud.functions.v2.LocationName;
import com.google.cloud.functions.v2.OperationMetadata;
import com.google.cloud.functions.v2.UpdateFunctionRequest;
import com.google.cloud.functions.v2.stub.FunctionServiceStub;
import com.google.cloud.functions.v2.stub.FunctionServiceStubSettings;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FunctionServiceClient
implements BackgroundResource {
    private final FunctionServiceSettings settings;
    private final FunctionServiceStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final FunctionServiceClient create() throws IOException {
        return FunctionServiceClient.create(FunctionServiceSettings.newBuilder().build());
    }

    public static final FunctionServiceClient create(FunctionServiceSettings settings) throws IOException {
        return new FunctionServiceClient(settings);
    }

    public static final FunctionServiceClient create(FunctionServiceStub stub) {
        return new FunctionServiceClient(stub);
    }

    protected FunctionServiceClient(FunctionServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FunctionServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create(this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create(this.stub.getHttpJsonOperationsStub());
    }

    protected FunctionServiceClient(FunctionServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create(this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create(this.stub.getHttpJsonOperationsStub());
    }

    public final FunctionServiceSettings getSettings() {
        return this.settings;
    }

    public FunctionServiceStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Function getFunction(FunctionName name) {
        GetFunctionRequest request = GetFunctionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFunction(request);
    }

    public final Function getFunction(String name) {
        GetFunctionRequest request = GetFunctionRequest.newBuilder().setName(name).build();
        return this.getFunction(request);
    }

    public final Function getFunction(GetFunctionRequest request) {
        return this.getFunctionCallable().call(request);
    }

    public final UnaryCallable<GetFunctionRequest, Function> getFunctionCallable() {
        return this.stub.getFunctionCallable();
    }

    public final ListFunctionsPagedResponse listFunctions(LocationName parent) {
        ListFunctionsRequest request = ListFunctionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listFunctions(request);
    }

    public final ListFunctionsPagedResponse listFunctions(String parent) {
        ListFunctionsRequest request = ListFunctionsRequest.newBuilder().setParent(parent).build();
        return this.listFunctions(request);
    }

    public final ListFunctionsPagedResponse listFunctions(ListFunctionsRequest request) {
        return this.listFunctionsPagedCallable().call(request);
    }

    public final UnaryCallable<ListFunctionsRequest, ListFunctionsPagedResponse> listFunctionsPagedCallable() {
        return this.stub.listFunctionsPagedCallable();
    }

    public final UnaryCallable<ListFunctionsRequest, ListFunctionsResponse> listFunctionsCallable() {
        return this.stub.listFunctionsCallable();
    }

    public final OperationFuture<Function, OperationMetadata> createFunctionAsync(LocationName parent, Function function, String functionId) {
        CreateFunctionRequest request = CreateFunctionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setFunction(function).setFunctionId(functionId).build();
        return this.createFunctionAsync(request);
    }

    public final OperationFuture<Function, OperationMetadata> createFunctionAsync(String parent, Function function, String functionId) {
        CreateFunctionRequest request = CreateFunctionRequest.newBuilder().setParent(parent).setFunction(function).setFunctionId(functionId).build();
        return this.createFunctionAsync(request);
    }

    public final OperationFuture<Function, OperationMetadata> createFunctionAsync(CreateFunctionRequest request) {
        return this.createFunctionOperationCallable().futureCall(request);
    }

    public final OperationCallable<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationCallable() {
        return this.stub.createFunctionOperationCallable();
    }

    public final UnaryCallable<CreateFunctionRequest, Operation> createFunctionCallable() {
        return this.stub.createFunctionCallable();
    }

    public final OperationFuture<Function, OperationMetadata> updateFunctionAsync(Function function, FieldMask updateMask) {
        UpdateFunctionRequest request = UpdateFunctionRequest.newBuilder().setFunction(function).setUpdateMask(updateMask).build();
        return this.updateFunctionAsync(request);
    }

    public final OperationFuture<Function, OperationMetadata> updateFunctionAsync(UpdateFunctionRequest request) {
        return this.updateFunctionOperationCallable().futureCall(request);
    }

    public final OperationCallable<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationCallable() {
        return this.stub.updateFunctionOperationCallable();
    }

    public final UnaryCallable<UpdateFunctionRequest, Operation> updateFunctionCallable() {
        return this.stub.updateFunctionCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFunctionAsync(FunctionName name) {
        DeleteFunctionRequest request = DeleteFunctionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteFunctionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFunctionAsync(String name) {
        DeleteFunctionRequest request = DeleteFunctionRequest.newBuilder().setName(name).build();
        return this.deleteFunctionAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteFunctionAsync(DeleteFunctionRequest request) {
        return this.deleteFunctionOperationCallable().futureCall(request);
    }

    public final OperationCallable<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationCallable() {
        return this.stub.deleteFunctionOperationCallable();
    }

    public final UnaryCallable<DeleteFunctionRequest, Operation> deleteFunctionCallable() {
        return this.stub.deleteFunctionCallable();
    }

    public final GenerateUploadUrlResponse generateUploadUrl(GenerateUploadUrlRequest request) {
        return this.generateUploadUrlCallable().call(request);
    }

    public final UnaryCallable<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlCallable() {
        return this.stub.generateUploadUrlCallable();
    }

    public final GenerateDownloadUrlResponse generateDownloadUrl(GenerateDownloadUrlRequest request) {
        return this.generateDownloadUrlCallable().call(request);
    }

    public final UnaryCallable<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlCallable() {
        return this.stub.generateDownloadUrlCallable();
    }

    public final ListRuntimesResponse listRuntimes(LocationName parent) {
        ListRuntimesRequest request = ListRuntimesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRuntimes(request);
    }

    public final ListRuntimesResponse listRuntimes(String parent) {
        ListRuntimesRequest request = ListRuntimesRequest.newBuilder().setParent(parent).build();
        return this.listRuntimes(request);
    }

    public final ListRuntimesResponse listRuntimes(ListRuntimesRequest request) {
        return this.listRuntimesCallable().call(request);
    }

    public final UnaryCallable<ListRuntimesRequest, ListRuntimesResponse> listRuntimesCallable() {
        return this.stub.listRuntimesCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return this.listLocationsPagedCallable().call(request);
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return this.setIamPolicyCallable().call(request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return this.getIamPolicyCallable().call(request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return this.testIamPermissionsCallable().call(request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    @Override
    public final void close() {
        this.stub.close();
    }

    @Override
    public void shutdown() {
        this.stub.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        @Override
        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        @Override
        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        @Override
        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)input), MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super(page, ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFunctionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFunctionsRequest, ListFunctionsResponse, Function, ListFunctionsPage, ListFunctionsFixedSizeCollection> {
        private ListFunctionsFixedSizeCollection(List<ListFunctionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFunctionsFixedSizeCollection createEmptyCollection() {
            return new ListFunctionsFixedSizeCollection(null, 0);
        }

        @Override
        protected ListFunctionsFixedSizeCollection createCollection(List<ListFunctionsPage> pages, int collectionSize) {
            return new ListFunctionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFunctionsPage
    extends AbstractPage<ListFunctionsRequest, ListFunctionsResponse, Function, ListFunctionsPage> {
        private ListFunctionsPage(PageContext<ListFunctionsRequest, ListFunctionsResponse, Function> context, ListFunctionsResponse response) {
            super(context, response);
        }

        private static ListFunctionsPage createEmptyPage() {
            return new ListFunctionsPage(null, null);
        }

        @Override
        protected ListFunctionsPage createPage(PageContext<ListFunctionsRequest, ListFunctionsResponse, Function> context, ListFunctionsResponse response) {
            return new ListFunctionsPage(context, response);
        }

        @Override
        public ApiFuture<ListFunctionsPage> createPageAsync(PageContext<ListFunctionsRequest, ListFunctionsResponse, Function> context, ApiFuture<ListFunctionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFunctionsPagedResponse
    extends AbstractPagedListResponse<ListFunctionsRequest, ListFunctionsResponse, Function, ListFunctionsPage, ListFunctionsFixedSizeCollection> {
        public static ApiFuture<ListFunctionsPagedResponse> createAsync(PageContext<ListFunctionsRequest, ListFunctionsResponse, Function> context, ApiFuture<ListFunctionsResponse> futureResponse) {
            ApiFuture<ListFunctionsPage> futurePage = ListFunctionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListFunctionsPagedResponse((ListFunctionsPage)input), MoreExecutors.directExecutor());
        }

        private ListFunctionsPagedResponse(ListFunctionsPage page) {
            super(page, ListFunctionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

