/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.v2beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.functions.v2beta.CreateFunctionRequest;
import com.google.cloud.functions.v2beta.DeleteFunctionRequest;
import com.google.cloud.functions.v2beta.Function;
import com.google.cloud.functions.v2beta.FunctionServiceClient;
import com.google.cloud.functions.v2beta.GenerateDownloadUrlRequest;
import com.google.cloud.functions.v2beta.GenerateDownloadUrlResponse;
import com.google.cloud.functions.v2beta.GenerateUploadUrlRequest;
import com.google.cloud.functions.v2beta.GenerateUploadUrlResponse;
import com.google.cloud.functions.v2beta.GetFunctionRequest;
import com.google.cloud.functions.v2beta.ListFunctionsRequest;
import com.google.cloud.functions.v2beta.ListFunctionsResponse;
import com.google.cloud.functions.v2beta.ListRuntimesRequest;
import com.google.cloud.functions.v2beta.ListRuntimesResponse;
import com.google.cloud.functions.v2beta.OperationMetadata;
import com.google.cloud.functions.v2beta.UpdateFunctionRequest;
import com.google.cloud.functions.v2beta.stub.FunctionServiceStub;
import com.google.cloud.functions.v2beta.stub.GrpcFunctionServiceStub;
import com.google.cloud.functions.v2beta.stub.HttpJsonFunctionServiceStub;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class FunctionServiceStubSettings
extends StubSettings<FunctionServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/cloud-platform")).build();
    private final UnaryCallSettings<GetFunctionRequest, Function> getFunctionSettings;
    private final PagedCallSettings<ListFunctionsRequest, ListFunctionsResponse, FunctionServiceClient.ListFunctionsPagedResponse> listFunctionsSettings;
    private final UnaryCallSettings<CreateFunctionRequest, Operation> createFunctionSettings;
    private final OperationCallSettings<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationSettings;
    private final UnaryCallSettings<UpdateFunctionRequest, Operation> updateFunctionSettings;
    private final OperationCallSettings<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationSettings;
    private final UnaryCallSettings<DeleteFunctionRequest, Operation> deleteFunctionSettings;
    private final OperationCallSettings<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationSettings;
    private final UnaryCallSettings<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlSettings;
    private final UnaryCallSettings<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlSettings;
    private final UnaryCallSettings<ListRuntimesRequest, ListRuntimesResponse> listRuntimesSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, FunctionServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListFunctionsRequest, ListFunctionsResponse, Function> LIST_FUNCTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListFunctionsRequest, ListFunctionsResponse, Function>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListFunctionsRequest injectToken(ListFunctionsRequest payload, String token) {
            return ListFunctionsRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListFunctionsRequest injectPageSize(ListFunctionsRequest payload, int pageSize) {
            return ListFunctionsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListFunctionsRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListFunctionsResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Function> extractResources(ListFunctionsResponse payload) {
            return payload.getFunctionsList() == null ? ImmutableList.of() : payload.getFunctionsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListFunctionsRequest, ListFunctionsResponse, FunctionServiceClient.ListFunctionsPagedResponse> LIST_FUNCTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListFunctionsRequest, ListFunctionsResponse, FunctionServiceClient.ListFunctionsPagedResponse>(){

        @Override
        public ApiFuture<FunctionServiceClient.ListFunctionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListFunctionsRequest, ListFunctionsResponse> callable, ListFunctionsRequest request, ApiCallContext context, ApiFuture<ListFunctionsResponse> futureResponse) {
            PageContext<ListFunctionsRequest, ListFunctionsResponse, Function> pageContext = PageContext.create(callable, LIST_FUNCTIONS_PAGE_STR_DESC, request, context);
            return FunctionServiceClient.ListFunctionsPagedResponse.createAsync(pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, FunctionServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, FunctionServiceClient.ListLocationsPagedResponse>(){

        @Override
        public ApiFuture<FunctionServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext<ListLocationsRequest, ListLocationsResponse, Location> pageContext = PageContext.create(callable, LIST_LOCATIONS_PAGE_STR_DESC, request, context);
            return FunctionServiceClient.ListLocationsPagedResponse.createAsync(pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetFunctionRequest, Function> getFunctionSettings() {
        return this.getFunctionSettings;
    }

    public PagedCallSettings<ListFunctionsRequest, ListFunctionsResponse, FunctionServiceClient.ListFunctionsPagedResponse> listFunctionsSettings() {
        return this.listFunctionsSettings;
    }

    public UnaryCallSettings<CreateFunctionRequest, Operation> createFunctionSettings() {
        return this.createFunctionSettings;
    }

    public OperationCallSettings<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationSettings() {
        return this.createFunctionOperationSettings;
    }

    public UnaryCallSettings<UpdateFunctionRequest, Operation> updateFunctionSettings() {
        return this.updateFunctionSettings;
    }

    public OperationCallSettings<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationSettings() {
        return this.updateFunctionOperationSettings;
    }

    public UnaryCallSettings<DeleteFunctionRequest, Operation> deleteFunctionSettings() {
        return this.deleteFunctionSettings;
    }

    public OperationCallSettings<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationSettings() {
        return this.deleteFunctionOperationSettings;
    }

    public UnaryCallSettings<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlSettings() {
        return this.generateUploadUrlSettings;
    }

    public UnaryCallSettings<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlSettings() {
        return this.generateDownloadUrlSettings;
    }

    public UnaryCallSettings<ListRuntimesRequest, ListRuntimesResponse> listRuntimesSettings() {
        return this.listRuntimesSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, FunctionServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public FunctionServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcFunctionServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonFunctionServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    @Override
    public String getServiceName() {
        return "cloudfunctions";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudfunctions.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudfunctions.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.MAX_VALUE);
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return FunctionServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FunctionServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FunctionServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return FunctionServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected FunctionServiceStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.getFunctionSettings = settingsBuilder.getFunctionSettings().build();
        this.listFunctionsSettings = settingsBuilder.listFunctionsSettings().build();
        this.createFunctionSettings = settingsBuilder.createFunctionSettings().build();
        this.createFunctionOperationSettings = settingsBuilder.createFunctionOperationSettings().build();
        this.updateFunctionSettings = settingsBuilder.updateFunctionSettings().build();
        this.updateFunctionOperationSettings = settingsBuilder.updateFunctionOperationSettings().build();
        this.deleteFunctionSettings = settingsBuilder.deleteFunctionSettings().build();
        this.deleteFunctionOperationSettings = settingsBuilder.deleteFunctionOperationSettings().build();
        this.generateUploadUrlSettings = settingsBuilder.generateUploadUrlSettings().build();
        this.generateDownloadUrlSettings = settingsBuilder.generateDownloadUrlSettings().build();
        this.listRuntimesSettings = settingsBuilder.listRuntimesSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<FunctionServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetFunctionRequest, Function> getFunctionSettings;
        private final PagedCallSettings.Builder<ListFunctionsRequest, ListFunctionsResponse, FunctionServiceClient.ListFunctionsPagedResponse> listFunctionsSettings;
        private final UnaryCallSettings.Builder<CreateFunctionRequest, Operation> createFunctionSettings;
        private final OperationCallSettings.Builder<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationSettings;
        private final UnaryCallSettings.Builder<UpdateFunctionRequest, Operation> updateFunctionSettings;
        private final OperationCallSettings.Builder<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteFunctionRequest, Operation> deleteFunctionSettings;
        private final OperationCallSettings.Builder<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationSettings;
        private final UnaryCallSettings.Builder<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlSettings;
        private final UnaryCallSettings.Builder<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlSettings;
        private final UnaryCallSettings.Builder<ListRuntimesRequest, ListRuntimesResponse> listRuntimesSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, FunctionServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getFunctionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFunctionsSettings = PagedCallSettings.newBuilder(LIST_FUNCTIONS_PAGE_STR_FACT);
            this.createFunctionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFunctionOperationSettings = OperationCallSettings.newBuilder();
            this.updateFunctionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFunctionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteFunctionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFunctionOperationSettings = OperationCallSettings.newBuilder();
            this.generateUploadUrlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateDownloadUrlSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRuntimesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder(LIST_LOCATIONS_PAGE_STR_FACT);
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getFunctionSettings, this.listFunctionsSettings, this.createFunctionSettings, this.updateFunctionSettings, this.deleteFunctionSettings, this.generateUploadUrlSettings, this.generateDownloadUrlSettings, this.listRuntimesSettings, this.listLocationsSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(FunctionServiceStubSettings settings) {
            super(settings);
            this.getFunctionSettings = settings.getFunctionSettings.toBuilder();
            this.listFunctionsSettings = settings.listFunctionsSettings.toBuilder();
            this.createFunctionSettings = settings.createFunctionSettings.toBuilder();
            this.createFunctionOperationSettings = settings.createFunctionOperationSettings.toBuilder();
            this.updateFunctionSettings = settings.updateFunctionSettings.toBuilder();
            this.updateFunctionOperationSettings = settings.updateFunctionOperationSettings.toBuilder();
            this.deleteFunctionSettings = settings.deleteFunctionSettings.toBuilder();
            this.deleteFunctionOperationSettings = settings.deleteFunctionOperationSettings.toBuilder();
            this.generateUploadUrlSettings = settings.generateUploadUrlSettings.toBuilder();
            this.generateDownloadUrlSettings = settings.generateDownloadUrlSettings.toBuilder();
            this.listRuntimesSettings = settings.listRuntimesSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getFunctionSettings, this.listFunctionsSettings, this.createFunctionSettings, this.updateFunctionSettings, this.deleteFunctionSettings, this.generateUploadUrlSettings, this.generateDownloadUrlSettings, this.listRuntimesSettings, this.listLocationsSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings, new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FunctionServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(FunctionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(FunctionServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(FunctionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FunctionServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider(FunctionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(FunctionServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(FunctionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getFunctionSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            ((PagedCallSettings.Builder)builder.listFunctionsSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.createFunctionSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.updateFunctionSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.deleteFunctionSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.generateUploadUrlSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.generateDownloadUrlSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.listRuntimesSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            ((PagedCallSettings.Builder)builder.listLocationsSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params"));
            builder.createFunctionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params")).build()).setResponseTransformer(ProtoOperationTransformers.ResponseTransformer.create(Function.class)).setMetadataTransformer(ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm(OperationTimedPollAlgorithm.create(RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis(45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis(300000L)).build()));
            builder.updateFunctionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params")).build()).setResponseTransformer(ProtoOperationTransformers.ResponseTransformer.create(Function.class)).setMetadataTransformer(ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm(OperationTimedPollAlgorithm.create(RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis(45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis(300000L)).build()));
            builder.deleteFunctionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("no_retry_codes")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("no_retry_params")).build()).setResponseTransformer(ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer(ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm(OperationTimedPollAlgorithm.create(RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis(45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetFunctionRequest, Function> getFunctionSettings() {
            return this.getFunctionSettings;
        }

        public PagedCallSettings.Builder<ListFunctionsRequest, ListFunctionsResponse, FunctionServiceClient.ListFunctionsPagedResponse> listFunctionsSettings() {
            return this.listFunctionsSettings;
        }

        public UnaryCallSettings.Builder<CreateFunctionRequest, Operation> createFunctionSettings() {
            return this.createFunctionSettings;
        }

        public OperationCallSettings.Builder<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationSettings() {
            return this.createFunctionOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateFunctionRequest, Operation> updateFunctionSettings() {
            return this.updateFunctionSettings;
        }

        public OperationCallSettings.Builder<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationSettings() {
            return this.updateFunctionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteFunctionRequest, Operation> deleteFunctionSettings() {
            return this.deleteFunctionSettings;
        }

        public OperationCallSettings.Builder<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationSettings() {
            return this.deleteFunctionOperationSettings;
        }

        public UnaryCallSettings.Builder<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlSettings() {
            return this.generateUploadUrlSettings;
        }

        public UnaryCallSettings.Builder<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlSettings() {
            return this.generateDownloadUrlSettings;
        }

        public UnaryCallSettings.Builder<ListRuntimesRequest, ListRuntimesResponse> listRuntimesSettings() {
            return this.listRuntimesSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, FunctionServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public FunctionServiceStubSettings build() throws IOException {
            return new FunctionServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("no_retry_codes", ImmutableSet.copyOf(Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put("no_retry_params", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

