/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.v2beta.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.functions.v2beta.CreateFunctionRequest;
import com.google.cloud.functions.v2beta.DeleteFunctionRequest;
import com.google.cloud.functions.v2beta.Function;
import com.google.cloud.functions.v2beta.FunctionServiceClient;
import com.google.cloud.functions.v2beta.GenerateDownloadUrlRequest;
import com.google.cloud.functions.v2beta.GenerateDownloadUrlResponse;
import com.google.cloud.functions.v2beta.GenerateUploadUrlRequest;
import com.google.cloud.functions.v2beta.GenerateUploadUrlResponse;
import com.google.cloud.functions.v2beta.GetFunctionRequest;
import com.google.cloud.functions.v2beta.ListFunctionsRequest;
import com.google.cloud.functions.v2beta.ListFunctionsResponse;
import com.google.cloud.functions.v2beta.ListRuntimesRequest;
import com.google.cloud.functions.v2beta.ListRuntimesResponse;
import com.google.cloud.functions.v2beta.OperationMetadata;
import com.google.cloud.functions.v2beta.UpdateFunctionRequest;
import com.google.cloud.functions.v2beta.stub.FunctionServiceStub;
import com.google.cloud.functions.v2beta.stub.FunctionServiceStubSettings;
import com.google.cloud.functions.v2beta.stub.HttpJsonFunctionServiceCallableFactory;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.common.collect.ImmutableMap;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonFunctionServiceStub
extends FunctionServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(Function.getDescriptor()).add(OperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<GetFunctionRequest, Function> getFunctionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.functions.v2beta.FunctionService/GetFunction").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{name=projects/*/locations/*/functions/*}", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "revision", request.getRevision());
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Function.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListFunctionsRequest, ListFunctionsResponse> listFunctionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.functions.v2beta.FunctionService/ListFunctions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{parent=projects/*/locations/*}/functions", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", request.getFilter());
        serializer.putQueryParam(fields, "orderBy", request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", request.getPageToken());
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(ListFunctionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateFunctionRequest, Operation> createFunctionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.functions.v2beta.FunctionService/CreateFunction").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{parent=projects/*/locations/*}/functions", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "functionId", request.getFunctionId());
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("function", request.getFunction(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create(response)).build();
    private static final ApiMethodDescriptor<UpdateFunctionRequest, Operation> updateFunctionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.functions.v2beta.FunctionService/UpdateFunction").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{function.name=projects/*/locations/*/functions/*}", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "function.name", request.getFunction().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("function", request.getFunction(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create(response)).build();
    private static final ApiMethodDescriptor<DeleteFunctionRequest, Operation> deleteFunctionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.functions.v2beta.FunctionService/DeleteFunction").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{name=projects/*/locations/*/functions/*}", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create(response)).build();
    private static final ApiMethodDescriptor<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.functions.v2beta.FunctionService/GenerateUploadUrl").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{parent=projects/*/locations/*}/functions:generateUploadUrl", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearParent().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(GenerateUploadUrlResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.functions.v2beta.FunctionService/GenerateDownloadUrl").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{name=projects/*/locations/*/functions/*}:generateDownloadUrl", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearName().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(GenerateDownloadUrlResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListRuntimesRequest, ListRuntimesResponse> listRuntimesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.functions.v2beta.FunctionService/ListRuntimes").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{parent=projects/*/locations/*}/runtimes", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", request.getFilter());
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(ListRuntimesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{name=projects/*}/locations", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetIamPolicyRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/SetIamPolicy").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{resource=projects/*/locations/*/functions/*}:setIamPolicy", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearResource().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetIamPolicyRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/GetIamPolicy").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{resource=projects/*/locations/*/functions/*}:getIamPolicy", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(Policy.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.v1.IAMPolicy/TestIamPermissions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter(ProtoMessageRequestFormatter.newBuilder().setPath("/v2beta/{resource=projects/*/locations/*/functions/*}:testIamPermissions", request -> {
        HashMap<String, String> fields = new HashMap<String, String>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "resource", request.getResource());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", "json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", request.toBuilder().clearResource().build(), true)).build()).setResponseParser(ProtoMessageResponseParser.newBuilder().setDefaultInstance(TestIamPermissionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetFunctionRequest, Function> getFunctionCallable;
    private final UnaryCallable<ListFunctionsRequest, ListFunctionsResponse> listFunctionsCallable;
    private final UnaryCallable<ListFunctionsRequest, FunctionServiceClient.ListFunctionsPagedResponse> listFunctionsPagedCallable;
    private final UnaryCallable<CreateFunctionRequest, Operation> createFunctionCallable;
    private final OperationCallable<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationCallable;
    private final UnaryCallable<UpdateFunctionRequest, Operation> updateFunctionCallable;
    private final OperationCallable<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationCallable;
    private final UnaryCallable<DeleteFunctionRequest, Operation> deleteFunctionCallable;
    private final OperationCallable<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationCallable;
    private final UnaryCallable<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlCallable;
    private final UnaryCallable<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlCallable;
    private final UnaryCallable<ListRuntimesRequest, ListRuntimesResponse> listRuntimesCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, FunctionServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonFunctionServiceStub create(FunctionServiceStubSettings settings) throws IOException {
        return new HttpJsonFunctionServiceStub(settings, ClientContext.create(settings));
    }

    public static final HttpJsonFunctionServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonFunctionServiceStub(FunctionServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonFunctionServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonFunctionServiceStub(FunctionServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonFunctionServiceStub(FunctionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonFunctionServiceCallableFactory());
    }

    protected HttpJsonFunctionServiceStub(FunctionServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create(clientContext, callableFactory, typeRegistry, ImmutableMap.builder().put("google.longrunning.Operations.GetOperation", HttpRule.newBuilder().setGet("/v2beta/{name=projects/*/locations/*/operations/*}").build()).put("google.longrunning.Operations.ListOperations", HttpRule.newBuilder().setGet("/v2beta/{name=projects/*/locations/*}/operations").build()).build());
        HttpJsonCallSettings<GetFunctionRequest, Function> getFunctionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getFunctionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<ListFunctionsRequest, ListFunctionsResponse> listFunctionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listFunctionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<CreateFunctionRequest, Operation> createFunctionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createFunctionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<UpdateFunctionRequest, Operation> updateFunctionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateFunctionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("function.name", String.valueOf(request.getFunction().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<DeleteFunctionRequest, Operation> deleteFunctionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteFunctionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(generateUploadUrlMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(generateDownloadUrlMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<ListRuntimesRequest, ListRuntimesResponse> listRuntimesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRuntimesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<ListLocationsRequest, ListLocationsResponse> listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<SetIamPolicyRequest, Policy> setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<GetIamPolicyRequest, Policy> getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        HttpJsonCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("resource", String.valueOf(request.getResource()));
            return builder.build();
        }).build();
        this.getFunctionCallable = callableFactory.createUnaryCallable(getFunctionTransportSettings, settings.getFunctionSettings(), clientContext);
        this.listFunctionsCallable = callableFactory.createUnaryCallable(listFunctionsTransportSettings, settings.listFunctionsSettings(), clientContext);
        this.listFunctionsPagedCallable = callableFactory.createPagedCallable(listFunctionsTransportSettings, settings.listFunctionsSettings(), clientContext);
        this.createFunctionCallable = callableFactory.createUnaryCallable(createFunctionTransportSettings, settings.createFunctionSettings(), clientContext);
        this.createFunctionOperationCallable = callableFactory.createOperationCallable(createFunctionTransportSettings, settings.createFunctionOperationSettings(), clientContext, this.httpJsonOperationsStub);
        this.updateFunctionCallable = callableFactory.createUnaryCallable(updateFunctionTransportSettings, settings.updateFunctionSettings(), clientContext);
        this.updateFunctionOperationCallable = callableFactory.createOperationCallable(updateFunctionTransportSettings, settings.updateFunctionOperationSettings(), clientContext, this.httpJsonOperationsStub);
        this.deleteFunctionCallable = callableFactory.createUnaryCallable(deleteFunctionTransportSettings, settings.deleteFunctionSettings(), clientContext);
        this.deleteFunctionOperationCallable = callableFactory.createOperationCallable(deleteFunctionTransportSettings, settings.deleteFunctionOperationSettings(), clientContext, this.httpJsonOperationsStub);
        this.generateUploadUrlCallable = callableFactory.createUnaryCallable(generateUploadUrlTransportSettings, settings.generateUploadUrlSettings(), clientContext);
        this.generateDownloadUrlCallable = callableFactory.createUnaryCallable(generateDownloadUrlTransportSettings, settings.generateDownloadUrlSettings(), clientContext);
        this.listRuntimesCallable = callableFactory.createUnaryCallable(listRuntimesTransportSettings, settings.listRuntimesSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getFunctionMethodDescriptor);
        methodDescriptors.add(listFunctionsMethodDescriptor);
        methodDescriptors.add(createFunctionMethodDescriptor);
        methodDescriptors.add(updateFunctionMethodDescriptor);
        methodDescriptors.add(deleteFunctionMethodDescriptor);
        methodDescriptors.add(generateUploadUrlMethodDescriptor);
        methodDescriptors.add(generateDownloadUrlMethodDescriptor);
        methodDescriptors.add(listRuntimesMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(setIamPolicyMethodDescriptor);
        methodDescriptors.add(getIamPolicyMethodDescriptor);
        methodDescriptors.add(testIamPermissionsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<GetFunctionRequest, Function> getFunctionCallable() {
        return this.getFunctionCallable;
    }

    @Override
    public UnaryCallable<ListFunctionsRequest, ListFunctionsResponse> listFunctionsCallable() {
        return this.listFunctionsCallable;
    }

    @Override
    public UnaryCallable<ListFunctionsRequest, FunctionServiceClient.ListFunctionsPagedResponse> listFunctionsPagedCallable() {
        return this.listFunctionsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateFunctionRequest, Operation> createFunctionCallable() {
        return this.createFunctionCallable;
    }

    @Override
    public OperationCallable<CreateFunctionRequest, Function, OperationMetadata> createFunctionOperationCallable() {
        return this.createFunctionOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateFunctionRequest, Operation> updateFunctionCallable() {
        return this.updateFunctionCallable;
    }

    @Override
    public OperationCallable<UpdateFunctionRequest, Function, OperationMetadata> updateFunctionOperationCallable() {
        return this.updateFunctionOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteFunctionRequest, Operation> deleteFunctionCallable() {
        return this.deleteFunctionCallable;
    }

    @Override
    public OperationCallable<DeleteFunctionRequest, Empty, OperationMetadata> deleteFunctionOperationCallable() {
        return this.deleteFunctionOperationCallable;
    }

    @Override
    public UnaryCallable<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlCallable() {
        return this.generateUploadUrlCallable;
    }

    @Override
    public UnaryCallable<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlCallable() {
        return this.generateDownloadUrlCallable;
    }

    @Override
    public UnaryCallable<ListRuntimesRequest, ListRuntimesResponse> listRuntimesCallable() {
        return this.listRuntimesCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, FunctionServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    @Override
    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

