/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.functions;

import com.google.cloud.functions.v1.CloudFunctionsServiceClient;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsClientFactory;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsComponent;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsConfiguration;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsConstants;
import org.apache.camel.component.google.functions.GoogleCloudFunctionsProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="3.9.0", scheme="google-functions", title="Google Cloud Functions", syntax="google-functions:functionName", category={Category.CLOUD}, producerOnly=true, headersClass=GoogleCloudFunctionsConstants.class)
public class GoogleCloudFunctionsEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @UriParam
    private GoogleCloudFunctionsConfiguration configuration;
    private CloudFunctionsServiceClient cloudFunctionsClient;

    public GoogleCloudFunctionsEndpoint(String uri, GoogleCloudFunctionsComponent component, GoogleCloudFunctionsConfiguration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new GoogleCloudFunctionsProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from the google-functions endpoint: " + this.getEndpointUri());
    }

    public GoogleCloudFunctionsConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(GoogleCloudFunctionsConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.cloudFunctionsClient = this.configuration.getClient() != null ? this.configuration.getClient() : GoogleCloudFunctionsClientFactory.create(this.getCamelContext(), this.configuration);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.configuration.getClient() == null && this.cloudFunctionsClient != null) {
            this.cloudFunctionsClient.close();
        }
    }

    public CloudFunctionsServiceClient getClient() {
        return this.cloudFunctionsClient;
    }

    @Override
    public String getServiceUrl() {
        if (ObjectHelper.isNotEmpty(this.configuration.getFunctionName()) && ObjectHelper.isNotEmpty(ObjectHelper.isNotEmpty(this.configuration.getProject()) && ObjectHelper.isNotEmpty(this.configuration.getLocation()))) {
            return this.getServiceProtocol() + ":" + this.configuration.getProject() + ":" + this.configuration.getFunctionName() + ":" + this.configuration.getLocation();
        }
        return null;
    }

    @Override
    public String getServiceProtocol() {
        return "functions";
    }
}

