/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail;

import com.google.api.services.gmail.Gmail;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.mail.BatchGoogleMailClientFactory;
import org.apache.camel.component.google.mail.GoogleMailClientFactory;
import org.apache.camel.component.google.mail.GoogleMailComponentVerifierExtension;
import org.apache.camel.component.google.mail.GoogleMailConfiguration;
import org.apache.camel.component.google.mail.GoogleMailEndpoint;
import org.apache.camel.component.google.mail.internal.GoogleMailApiCollection;
import org.apache.camel.component.google.mail.internal.GoogleMailApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.component.AbstractApiComponent;

@Component(value="google-mail")
public class GoogleMailComponent
extends AbstractApiComponent<GoogleMailApiName, GoogleMailConfiguration, GoogleMailApiCollection> {
    @Metadata
    GoogleMailConfiguration configuration;
    @Metadata(label="advanced")
    private Gmail client;
    @Metadata(label="advanced")
    private GoogleMailClientFactory clientFactory;

    public GoogleMailComponent() {
        super(GoogleMailApiName.class, GoogleMailApiCollection.getCollection());
        this.registerExtension(new GoogleMailComponentVerifierExtension());
    }

    public GoogleMailComponent(CamelContext context) {
        super(context, GoogleMailApiName.class, GoogleMailApiCollection.getCollection());
        this.registerExtension(new GoogleMailComponentVerifierExtension());
    }

    @Override
    protected GoogleMailApiName getApiName(String apiNameStr) {
        return this.getCamelContext().getTypeConverter().convertTo(GoogleMailApiName.class, apiNameStr);
    }

    public Gmail getClient(GoogleMailConfiguration config) {
        if (this.client == null) {
            if (config.getClientId() != null && !config.getClientId().isBlank() && config.getClientSecret() != null && !config.getClientSecret().isBlank()) {
                this.client = this.getClientFactory().makeClient(config.getClientId(), config.getClientSecret(), config.getScopes(), config.getApplicationName(), config.getRefreshToken(), config.getAccessToken());
            } else if (config.getServiceAccountKey() != null && !config.getServiceAccountKey().isBlank()) {
                this.client = this.getClientFactory().makeClient(this.getCamelContext(), config.getServiceAccountKey(), config.getScopes(), config.getApplicationName(), config.getDelegate());
            } else {
                throw new IllegalArgumentException("(clientId and clientSecret) or serviceAccountKey are required to create Gmail client");
            }
        }
        return this.client;
    }

    public GoogleMailClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = new BatchGoogleMailClientFactory();
        }
        return this.clientFactory;
    }

    @Override
    public void setConfiguration(GoogleMailConfiguration configuration) {
        super.setConfiguration(configuration);
    }

    @Override
    public GoogleMailConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new GoogleMailConfiguration();
        }
        return (GoogleMailConfiguration)super.getConfiguration();
    }

    public void setClientFactory(GoogleMailClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    protected Endpoint createEndpoint(String uri, String methodName, GoogleMailApiName apiName, GoogleMailConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new GoogleMailEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }
}

