/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.LoggingLevel;
import org.apache.camel.PollingConsumerPollingStrategy;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckAware;
import org.apache.camel.spi.HttpResponseAware;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;
import org.apache.camel.support.DefaultConsumer;
import org.apache.camel.support.DefaultPollingConsumerPollStrategy;
import org.apache.camel.support.DefaultScheduledPollConsumerScheduler;
import org.apache.camel.support.HealthCheckComponent;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.ScheduledPollConsumerHealthCheck;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScheduledPollConsumer
extends DefaultConsumer
implements Runnable,
Suspendable,
PollingConsumerPollingStrategy,
HealthCheckAware {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledPollConsumer.class);
    private ScheduledPollConsumerScheduler scheduler;
    private ScheduledExecutorService scheduledExecutorService;
    private boolean startScheduler = true;
    private long initialDelay = 1000L;
    private long delay = 500L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private boolean useFixedDelay = true;
    private PollingConsumerPollStrategy pollStrategy;
    private LoggingLevel runLoggingLevel = LoggingLevel.TRACE;
    private boolean sendEmptyMessageWhenIdle;
    private boolean greedy;
    private int backoffMultiplier;
    private int backoffIdleThreshold;
    private int backoffErrorThreshold;
    private long repeatCount;
    private Map<String, Object> schedulerProperties;
    private volatile boolean polling;
    private final AtomicInteger backoffCounter = new AtomicInteger();
    private final AtomicLong idleCounter = new AtomicLong();
    private final AtomicLong errorCounter = new AtomicLong();
    private final AtomicLong successCounter = new AtomicLong();
    private volatile Throwable lastError;
    private volatile Map<String, Object> lastErrorDetails;
    private final AtomicLong counter = new AtomicLong();
    private volatile boolean firstPollDone;
    private volatile boolean forceReady;

    public ScheduledPollConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    public ScheduledPollConsumer(Endpoint endpoint, Processor processor, ScheduledExecutorService scheduledExecutorService) {
        super(endpoint, processor);
        this.scheduledExecutorService = scheduledExecutorService;
        ObjectHelper.notNull(scheduledExecutorService, "scheduledExecutorService");
    }

    @Override
    public void run() {
        try {
            if (LoggingLevel.ERROR == this.runLoggingLevel) {
                LOG.error("Scheduled task started on:   {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.WARN == this.runLoggingLevel) {
                LOG.warn("Scheduled task started on:   {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.INFO == this.runLoggingLevel) {
                LOG.info("Scheduled task started on:   {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.DEBUG == this.runLoggingLevel) {
                LOG.debug("Scheduled task started on:   {}", (Object)this.getEndpoint());
            } else {
                LOG.trace("Scheduled task started on:   {}", (Object)this.getEndpoint());
            }
            this.doRun();
            if (LoggingLevel.ERROR == this.runLoggingLevel) {
                LOG.error("Scheduled task completed on: {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.WARN == this.runLoggingLevel) {
                LOG.warn("Scheduled task completed on: {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.INFO == this.runLoggingLevel) {
                LOG.info("Scheduled task completed on: {}", (Object)this.getEndpoint());
            } else if (LoggingLevel.DEBUG == this.runLoggingLevel) {
                LOG.debug("Scheduled task completed on: {}", (Object)this.getEndpoint());
            } else {
                LOG.trace("Scheduled task completed on: {}", (Object)this.getEndpoint());
            }
        }
        catch (Error e) {
            LOG.error("Error occurred during running scheduled task on: {}, due: {}. This exception is ignored and the task will run again on next poll.", new Object[]{this.getEndpoint(), e.getMessage(), e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun() {
        boolean stopFire;
        if (this.isSuspended()) {
            LOG.trace("Cannot start to poll: {} as its suspended", (Object)this.getEndpoint());
            return;
        }
        if (this.backoffMultiplier > 0 && this.idleCounter.longValue() >= (long)(this.backoffIdleThreshold > 0 ? this.backoffIdleThreshold : Integer.MAX_VALUE) || this.errorCounter.longValue() >= (long)(this.backoffErrorThreshold > 0 ? this.backoffErrorThreshold : Integer.MAX_VALUE)) {
            int currentBackoffCounter = this.backoffCounter.incrementAndGet();
            if (currentBackoffCounter < this.backoffMultiplier) {
                if (this.idleCounter.intValue() > 0) {
                    LOG.debug("doRun() backoff due subsequent {} idles (backoff at {}/{})", new Object[]{this.idleCounter.longValue(), this.backoffCounter.intValue(), this.backoffMultiplier});
                } else {
                    LOG.debug("doRun() backoff due subsequent {} errors (backoff at {}/{})", new Object[]{this.errorCounter.intValue(), this.backoffCounter.intValue(), this.backoffMultiplier});
                }
                return;
            }
            this.idleCounter.set(0L);
            this.errorCounter.set(0L);
            this.backoffCounter.set(0);
            this.successCounter.set(0L);
            LOG.trace("doRun() backoff finished, resetting counters.");
        }
        long count = this.counter.incrementAndGet();
        boolean bl = stopFire = this.repeatCount > 0L && count > this.repeatCount;
        if (stopFire) {
            LOG.debug("Cancelling {} scheduler as repeat count limit reached after {} counts.", (Object)this.getEndpoint(), (Object)this.repeatCount);
            this.scheduler.unscheduleTask();
            return;
        }
        int retryCounter = -1;
        boolean done = false;
        Exception cause = null;
        int polledMessages = 0;
        while (!done) {
            try {
                done = true;
                if (this.isPollAllowed()) {
                    if (retryCounter == -1) {
                        LOG.trace("Starting to poll: {}", (Object)this.getEndpoint());
                    } else {
                        LOG.debug("Retrying attempt {} to poll: {}", (Object)retryCounter, (Object)this.getEndpoint());
                    }
                    this.polling = true;
                    try {
                        boolean begin = this.pollStrategy.begin(this, this.getEndpoint());
                        if (begin) {
                            ++retryCounter;
                            polledMessages = this.poll();
                            LOG.trace("Polled {} messages", (Object)polledMessages);
                            if (polledMessages == 0 && this.isSendEmptyMessageWhenIdle()) {
                                this.processEmptyMessage();
                            }
                            this.pollStrategy.commit(this, this.getEndpoint(), polledMessages);
                            if (polledMessages > 0 && this.isGreedy()) {
                                done = false;
                                retryCounter = -1;
                                LOG.trace("Greedy polling after processing {} messages", (Object)polledMessages);
                                this.errorCounter.set(0L);
                                this.lastError = null;
                                this.lastErrorDetails = null;
                                this.firstPollDone = true;
                            }
                        } else {
                            LOG.debug("Cannot begin polling as pollStrategy returned false: {}", (Object)this.pollStrategy);
                        }
                    }
                    finally {
                        this.polling = false;
                    }
                }
                LOG.trace("Finished polling: {}", (Object)this.getEndpoint());
            }
            catch (Exception e) {
                try {
                    boolean retry = this.pollStrategy.rollback(this, this.getEndpoint(), retryCounter, e);
                    if (retry) {
                        done = false;
                    } else {
                        cause = e;
                        done = true;
                    }
                }
                catch (Exception t2) {
                    cause = t2;
                    done = true;
                }
            }
            if (cause == null || !this.isRunAllowed()) continue;
            try {
                this.getExceptionHandler().handleException("Failed polling endpoint: " + String.valueOf(this.getEndpoint()) + ". Will try again at next poll", cause);
            }
            catch (Exception e) {
                LOG.warn("Error handling exception. This exception will be ignored.", (Throwable)e);
            }
        }
        if (cause != null) {
            HttpResponseAware httpResponseAware;
            int code;
            this.idleCounter.set(0L);
            this.successCounter.set(0L);
            this.errorCounter.incrementAndGet();
            this.lastError = cause;
            if (cause instanceof HttpResponseAware && (code = (httpResponseAware = (HttpResponseAware)((Object)cause)).getHttpResponseCode()) > 0) {
                this.addLastErrorDetail("http.response.code", code);
            }
        } else {
            if (polledMessages == 0) {
                this.idleCounter.incrementAndGet();
            } else {
                this.idleCounter.set(0L);
            }
            this.successCounter.incrementAndGet();
            this.errorCounter.set(0L);
            this.lastError = null;
            this.lastErrorDetails = null;
        }
        this.firstPollDone = true;
        LOG.trace("doRun() done with idleCounter={}, successCounter={}, errorCounter={}", new Object[]{this.idleCounter.longValue(), this.successCounter.longValue(), this.errorCounter.longValue()});
    }

    protected void processEmptyMessage() throws Exception {
        Exchange exchange = this.getEndpoint().createExchange();
        LOG.debug("Sending empty message as there were no messages from polling: {}", (Object)this.getEndpoint());
        this.getProcessor().process(exchange);
    }

    protected boolean isPollAllowed() {
        return this.isRunAllowed() && !this.isSuspended();
    }

    public boolean isPolling() {
        return this.polling;
    }

    public ScheduledPollConsumerScheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(ScheduledPollConsumerScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Map<String, Object> getSchedulerProperties() {
        return this.schedulerProperties;
    }

    public void setSchedulerProperties(Map<String, Object> schedulerProperties) {
        this.schedulerProperties = schedulerProperties;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public boolean isUseFixedDelay() {
        return this.useFixedDelay;
    }

    public void setUseFixedDelay(boolean useFixedDelay) {
        this.useFixedDelay = useFixedDelay;
    }

    public LoggingLevel getRunLoggingLevel() {
        return this.runLoggingLevel;
    }

    public void setRunLoggingLevel(LoggingLevel runLoggingLevel) {
        this.runLoggingLevel = runLoggingLevel;
    }

    public PollingConsumerPollStrategy getPollStrategy() {
        return this.pollStrategy;
    }

    public void setPollStrategy(PollingConsumerPollStrategy pollStrategy) {
        this.pollStrategy = pollStrategy;
    }

    public boolean isStartScheduler() {
        return this.startScheduler;
    }

    public void setStartScheduler(boolean startScheduler) {
        this.startScheduler = startScheduler;
    }

    public void setSendEmptyMessageWhenIdle(boolean sendEmptyMessageWhenIdle) {
        this.sendEmptyMessageWhenIdle = sendEmptyMessageWhenIdle;
    }

    public boolean isSendEmptyMessageWhenIdle() {
        return this.sendEmptyMessageWhenIdle;
    }

    public boolean isGreedy() {
        return this.greedy;
    }

    public void setGreedy(boolean greedy) {
        this.greedy = greedy;
    }

    public int getBackoffCounter() {
        return this.backoffCounter.intValue();
    }

    public int getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public void setBackoffMultiplier(int backoffMultiplier) {
        this.backoffMultiplier = backoffMultiplier;
    }

    public int getBackoffIdleThreshold() {
        return this.backoffIdleThreshold;
    }

    public void setBackoffIdleThreshold(int backoffIdleThreshold) {
        this.backoffIdleThreshold = backoffIdleThreshold;
    }

    public int getBackoffErrorThreshold() {
        return this.backoffErrorThreshold;
    }

    public void setBackoffErrorThreshold(int backoffErrorThreshold) {
        this.backoffErrorThreshold = backoffErrorThreshold;
    }

    public long getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(long repeatCount) {
        this.repeatCount = repeatCount;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public boolean isSchedulerStarted() {
        return this.scheduler.isSchedulerStarted();
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public long getErrorCounter() {
        return this.errorCounter.longValue();
    }

    public long getSuccessCounter() {
        return this.successCounter.longValue();
    }

    public long getCounter() {
        return this.counter.get();
    }

    public boolean isFirstPollDone() {
        return this.firstPollDone;
    }

    public boolean isConsumerReady() {
        return this.forceReady || this.firstPollDone;
    }

    protected void forceConsumerAsReady() {
        this.forceReady = true;
    }

    protected Throwable getLastError() {
        return this.lastError;
    }

    protected Map<String, Object> getLastErrorDetails() {
        return this.lastErrorDetails;
    }

    protected void addLastErrorDetail(String key, Object value) {
        if (this.lastErrorDetails == null) {
            this.lastErrorDetails = new HashMap<String, Object>();
        }
        if (this.lastErrorDetails != null) {
            this.lastErrorDetails.put(key, value);
        }
    }

    protected abstract int poll() throws Exception;

    @Override
    protected void doBuild() throws Exception {
        if (this.getHealthCheck() == null) {
            String id = "consumer:" + this.getRouteId();
            ScheduledPollConsumerHealthCheck hc = new ScheduledPollConsumerHealthCheck(this, id);
            HealthCheck.State initialState = this.initialHealthCheckState();
            if (initialState != null) {
                hc.setInitialState(initialState);
            }
            this.setHealthCheck(hc);
        }
        super.doBuild();
    }

    protected HealthCheck.State initialHealthCheckState() {
        return null;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        Component component = this.getEndpoint().getComponent();
        if (component instanceof HealthCheckComponent) {
            HealthCheckComponent hcc = (HealthCheckComponent)component;
            this.getHealthCheck().setEnabled(hcc.isHealthCheckConsumerEnabled());
        }
        if (this.backoffMultiplier > 0) {
            if (this.backoffIdleThreshold <= 0 && this.backoffErrorThreshold <= 0) {
                throw new IllegalArgumentException("backoffIdleThreshold and/or backoffErrorThreshold must be configured to a positive value when using backoffMultiplier");
            }
            LOG.debug("Using backoff[multiplier={}, idleThreshold={}, errorThreshold={}] on {}", new Object[]{this.backoffMultiplier, this.backoffIdleThreshold, this.backoffErrorThreshold, this.getEndpoint()});
        }
        if (this.pollStrategy == null) {
            this.pollStrategy = new DefaultPollingConsumerPollStrategy();
        }
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        boolean newScheduler = false;
        if (this.scheduler == null) {
            DefaultScheduledPollConsumerScheduler scheduler = new DefaultScheduledPollConsumerScheduler(this.scheduledExecutorService);
            scheduler.setDelay(this.delay);
            scheduler.setInitialDelay(this.initialDelay);
            scheduler.setTimeUnit(this.timeUnit);
            scheduler.setUseFixedDelay(this.useFixedDelay);
            this.scheduler = scheduler;
            newScheduler = true;
        }
        ObjectHelper.notNull(this.scheduler, "scheduler", this);
        this.scheduler.setCamelContext(this.getEndpoint().getCamelContext());
        if (this.schedulerProperties != null && !this.schedulerProperties.isEmpty()) {
            LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(this.schedulerProperties);
            PropertyBindingSupport.build().bind(this.getEndpoint().getCamelContext(), this.scheduler, copy);
            Map<String, Object> triggerParameters = PropertiesHelper.extractProperties(copy, "trigger.");
            Map<String, Object> jobParameters = PropertiesHelper.extractProperties(copy, "job.");
            PropertyBindingSupport.build().bind(this.getEndpoint().getCamelContext(), this.scheduler, "triggerParameters", triggerParameters);
            PropertyBindingSupport.build().bind(this.getEndpoint().getCamelContext(), this.scheduler, "jobParameters", jobParameters);
            if (!copy.isEmpty()) {
                throw new FailedToCreateConsumerException(this.getEndpoint(), "There are " + copy.size() + " scheduler parameters that couldn't be set on the endpoint. Check the uri if the parameters are spelt correctly and that they are properties of the endpoint. Unknown parameters=[" + String.valueOf(copy) + "]");
            }
        }
        this.afterConfigureScheduler(this.scheduler, newScheduler);
        this.scheduler.onInit(this);
        if (this.scheduler != null) {
            this.scheduler.scheduleTask(this);
            ServiceHelper.startService(this.scheduler);
            if (this.isStartScheduler()) {
                this.startScheduler();
            }
        }
    }

    protected void afterConfigureScheduler(ScheduledPollConsumerScheduler scheduler, boolean newScheduler) {
    }

    public void startScheduler() {
        this.scheduler.startScheduler();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.scheduler != null) {
            this.scheduler.unscheduleTask();
            ServiceHelper.stopAndShutdownServices(this.scheduler);
        }
        this.backoffCounter.set(0);
        this.idleCounter.set(0L);
        this.errorCounter.set(0L);
        this.successCounter.set(0L);
        this.counter.set(0L);
        this.firstPollDone = false;
        this.forceReady = false;
        super.doStop();
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.scheduler);
        super.doShutdown();
    }

    @Override
    protected void doSuspend() throws Exception {
    }

    @Override
    public void onInit() throws Exception {
        this.startScheduler = true;
    }

    @Override
    public long beforePoll(long timeout) throws Exception {
        LOG.trace("Before poll {}", (Object)this.getEndpoint());
        if (!ServiceHelper.resumeService(this)) {
            ServiceHelper.startService(this);
        }
        return Math.max(timeout, this.getDelay());
    }

    @Override
    public void afterPoll() throws Exception {
        LOG.trace("After poll {}", (Object)this.getEndpoint());
        if (!ServiceHelper.suspendService(this)) {
            ServiceHelper.stopService(this);
        }
    }
}

