/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.gmail.Gmail;
import java.io.IOException;
import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.mail.GoogleMailClientFactory;
import org.apache.camel.support.ResourceHelper;

public class BatchGoogleMailClientFactory
implements GoogleMailClientFactory {
    private NetHttpTransport transport = new NetHttpTransport();
    private JacksonFactory jsonFactory = new JacksonFactory();

    @Override
    public Gmail makeClient(String clientId, String clientSecret, Collection<String> scopes, String applicationName, String refreshToken, String accessToken) {
        if (clientId == null || clientSecret == null) {
            throw new IllegalArgumentException("clientId and clientSecret are required to create Gmail client.");
        }
        try {
            Credential credential = this.authorize(clientId, clientSecret);
            if (refreshToken != null && !refreshToken.isEmpty()) {
                credential.setRefreshToken(refreshToken);
            }
            if (accessToken != null && !accessToken.isEmpty()) {
                credential.setAccessToken(accessToken);
            }
            return new Gmail.Builder(this.transport, this.jsonFactory, credential).setApplicationName(applicationName).build();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Could not create Gmail client.", e);
        }
    }

    private Credential authorize(String clientId, String clientSecret) {
        return new GoogleCredential.Builder().setJsonFactory(this.jsonFactory).setTransport(this.transport).setClientSecrets(clientId, clientSecret).build();
    }

    @Override
    public Gmail makeClient(CamelContext camelContext, String serviceAccountKey, Collection<String> scopes, String applicationName, String delegate) {
        if (serviceAccountKey == null) {
            throw new IllegalArgumentException("serviceAccountKey is required to create Gmail client.");
        }
        try {
            Credential credential = this.authorizeServiceAccount(camelContext, serviceAccountKey, delegate, scopes);
            return new Gmail.Builder(this.transport, this.jsonFactory, credential).setApplicationName(applicationName).build();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Could not create Gmail client.", e);
        }
    }

    private Credential authorizeServiceAccount(CamelContext camelContext, String serviceAccountKey, String delegate, Collection<String> scopes) {
        try {
            GoogleCredential cred = GoogleCredential.fromStream(ResourceHelper.resolveMandatoryResourceAsInputStream(camelContext, serviceAccountKey), this.transport, this.jsonFactory).createScoped(scopes != null && !scopes.isEmpty() ? scopes : null).createDelegated(delegate);
            cred.refreshToken();
            return cred;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

