/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail.stream;

import com.google.api.client.util.Base64;
import com.google.api.services.gmail.Gmail;
import com.google.api.services.gmail.model.ListMessagesResponse;
import com.google.api.services.gmail.model.MessagePart;
import com.google.api.services.gmail.model.MessagePartHeader;
import com.google.api.services.gmail.model.ModifyMessageRequest;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamConfiguration;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamEndpoint;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.EmptyAsyncCallback;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleMailStreamConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleMailStreamConsumer.class);
    private String unreadLabelId;
    private List<String> labelsIds;

    public GoogleMailStreamConsumer(Endpoint endpoint, Processor processor, String unreadLabelId, List<String> labelsIds) {
        super(endpoint, processor);
        this.unreadLabelId = unreadLabelId;
        this.labelsIds = labelsIds;
    }

    protected GoogleMailStreamConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected Gmail getClient() {
        return this.getEndpoint().getClient();
    }

    @Override
    public GoogleMailStreamEndpoint getEndpoint() {
        return (GoogleMailStreamEndpoint)super.getEndpoint();
    }

    @Override
    protected int poll() throws Exception {
        Gmail.Users.Messages.List request = this.getClient().users().messages().list("me");
        if (ObjectHelper.isNotEmpty(this.getConfiguration().getQuery())) {
            request.setQ(this.getConfiguration().getQuery());
        }
        if (ObjectHelper.isNotEmpty(this.getConfiguration().getMaxResults())) {
            request.setMaxResults(this.getConfiguration().getMaxResults());
        }
        if (ObjectHelper.isNotEmpty(this.labelsIds)) {
            request.setLabelIds(this.labelsIds);
        }
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        ListMessagesResponse c = (ListMessagesResponse)request.execute();
        this.forceConsumerAsReady();
        if (c.getMessages() != null) {
            for (com.google.api.services.gmail.model.Message message : c.getMessages()) {
                com.google.api.services.gmail.model.Message mess = (com.google.api.services.gmail.model.Message)this.getClient().users().messages().get("me", message.getId()).setFormat("FULL").execute();
                Exchange exchange = this.createExchange(this.getEndpoint().getExchangePattern(), mess);
                answer.add(exchange);
            }
        }
        return this.processBatch(CastUtils.cast(answer));
    }

    @Override
    public int processBatch(Queue<Object> exchanges) {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = ObjectHelper.cast(Exchange.class, exchanges.poll());
            exchange.setProperty(ExchangePropertyKey.BATCH_INDEX, (Object)index);
            exchange.setProperty(ExchangePropertyKey.BATCH_SIZE, (Object)total);
            exchange.setProperty(ExchangePropertyKey.BATCH_COMPLETE, (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            exchange.getExchangeExtension().addOnCompletion(new Synchronization(){

                @Override
                public void onComplete(Exchange exchange) {
                    GoogleMailStreamConsumer.this.processCommit(exchange, GoogleMailStreamConsumer.this.unreadLabelId);
                }

                @Override
                public void onFailure(Exchange exchange) {
                    GoogleMailStreamConsumer.this.processRollback(exchange, GoogleMailStreamConsumer.this.unreadLabelId);
                }

                public String toString() {
                    return "GoogleMailStreamConsumerOnCompletion";
                }
            });
            this.getAsyncProcessor().process(exchange, EmptyAsyncCallback.get());
        }
        return total;
    }

    protected void processCommit(Exchange exchange, String unreadLabelId) {
        try {
            if (this.getConfiguration().isMarkAsRead()) {
                String id = exchange.getIn().getHeader("CamelGoogleMailId", String.class);
                LOG.trace("Marking email {} as read", (Object)id);
                ArrayList<String> remove = new ArrayList<String>();
                remove.add(unreadLabelId);
                ModifyMessageRequest mods = new ModifyMessageRequest().setRemoveLabelIds(remove);
                this.getClient().users().messages().modify("me", exchange.getIn().getHeader("CamelGoogleMailId", String.class), mods).execute();
                LOG.trace("Marked email {} as read", (Object)id);
            }
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error occurred mark as read mail. This exception is ignored.", exchange, e);
        }
    }

    protected void processRollback(Exchange exchange, String unreadLabelId) {
        try {
            LOG.warn("Exchange failed, so rolling back mail {} to un {}", (Object)exchange, (Object)unreadLabelId);
            ArrayList<String> add = new ArrayList<String>();
            add.add(unreadLabelId);
            ModifyMessageRequest mods = new ModifyMessageRequest().setAddLabelIds(add);
            this.getClient().users().messages().modify("me", exchange.getIn().getHeader("CamelGoogleMailId", String.class), mods).execute();
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error occurred mark as read mail. This exception is ignored.", exchange, e);
        }
    }

    public Exchange createExchange(ExchangePattern pattern, com.google.api.services.gmail.model.Message mail) {
        Exchange exchange = this.createExchange(true);
        exchange.setPattern(pattern);
        Message message = exchange.getIn();
        exchange.getIn().setHeader("CamelGoogleMailId", mail.getId());
        if (this.getConfiguration().isRaw()) {
            message.setBody(mail.getRaw());
        } else {
            List<MessagePart> parts = mail.getPayload().getParts();
            if (parts != null && parts.get(0).getBody().getData() != null) {
                byte[] bodyBytes = Base64.decodeBase64(parts.get(0).getBody().getData().trim());
                String body = new String(bodyBytes, StandardCharsets.UTF_8);
                message.setBody(body);
            }
        }
        this.configureHeaders(message, mail.getPayload().getHeaders());
        return exchange;
    }

    private void configureHeaders(Message message, List<MessagePartHeader> headers) {
        for (MessagePartHeader header : headers) {
            String headerName = header.getName();
            if ("SUBJECT".equalsIgnoreCase(headerName)) {
                message.setHeader("CamelGoogleMailStreamSubject", header.getValue());
            }
            if ("TO".equalsIgnoreCase(headerName)) {
                message.setHeader("CamelGoogleMailStreamTo", header.getValue());
            }
            if ("FROM".equalsIgnoreCase(headerName)) {
                message.setHeader("CamelGoogleMailStreamFrom", header.getValue());
            }
            if ("CC".equalsIgnoreCase(headerName)) {
                message.setHeader("CamelGoogleMailStreamCc", header.getValue());
            }
            if (!"BCC".equalsIgnoreCase(headerName)) continue;
            message.setHeader("CamelGoogleMailStreamBcc", header.getValue());
        }
    }
}

