/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail.stream;

import com.google.api.services.gmail.Gmail;
import com.google.api.services.gmail.model.Label;
import com.google.api.services.gmail.model.ListLabelsResponse;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.mail.GoogleMailClientFactory;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamComponent;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamConfiguration;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamConstants;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamConsumer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.22.0", scheme="google-mail-stream", title="Google Mail Stream", syntax="google-mail-stream:index", consumerOnly=true, category={Category.CLOUD, Category.MAIL}, headersClass=GoogleMailStreamConstants.class)
public class GoogleMailStreamEndpoint
extends ScheduledPollEndpoint
implements EndpointServiceLocation {
    @UriParam
    private GoogleMailStreamConfiguration configuration;

    public GoogleMailStreamEndpoint(String uri, GoogleMailStreamComponent component, GoogleMailStreamConfiguration endpointConfiguration) {
        super(uri, component);
        this.configuration = endpointConfiguration;
    }

    @Override
    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("The camel google mail stream component doesn't support producer");
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        String unreadLabelId = null;
        ArrayList<String> labelsIds = new ArrayList<String>();
        ListLabelsResponse listResponse = (ListLabelsResponse)this.getClient().users().labels().list("me").execute();
        for (Label label : listResponse.getLabels()) {
            Label countLabel = (Label)this.getClient().users().labels().get("me", label.getId()).execute();
            if (!countLabel.getName().equalsIgnoreCase("UNREAD")) continue;
            unreadLabelId = countLabel.getId();
        }
        if (ObjectHelper.isNotEmpty(this.getConfiguration().getLabels())) {
            List<String> plainLabels = this.splitLabels(this.getConfiguration().getLabels());
            for (Label label : listResponse.getLabels()) {
                Label countLabel = (Label)this.getClient().users().labels().get("me", label.getId()).execute();
                for (String plainLabel : plainLabels) {
                    if (!countLabel.getName().equalsIgnoreCase(plainLabel)) continue;
                    labelsIds.add(countLabel.getId());
                }
            }
        }
        GoogleMailStreamConsumer consumer = new GoogleMailStreamConsumer(this, processor, unreadLabelId, labelsIds);
        this.configureConsumer(consumer);
        return consumer;
    }

    public Gmail getClient() {
        return ((GoogleMailStreamComponent)this.getComponent()).getClient(this.configuration);
    }

    public GoogleMailClientFactory getClientFactory() {
        return ((GoogleMailStreamComponent)this.getComponent()).getClientFactory();
    }

    public void setClientFactory(GoogleMailClientFactory clientFactory) {
        ((GoogleMailStreamComponent)this.getComponent()).setClientFactory(clientFactory);
    }

    public GoogleMailStreamConfiguration getConfiguration() {
        return this.configuration;
    }

    private List<String> splitLabels(String labels) {
        return Splitter.on(',').splitToList(labels);
    }

    @Override
    public String getServiceUrl() {
        if (ObjectHelper.isNotEmpty(ObjectHelper.isNotEmpty(this.configuration.getApplicationName()) && ObjectHelper.isNotEmpty(this.configuration.getIndex()))) {
            return this.getServiceProtocol() + ":" + this.configuration.getApplicationName() + ":" + this.configuration.getIndex();
        }
        return null;
    }

    @Override
    public String getServiceProtocol() {
        return "mail-stream";
    }
}

